/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.external.facebook.stetho.inspector.network;

import com.moesif.external.facebook.stetho.inspector.network.CountingOutputStream;
import com.moesif.external.facebook.stetho.inspector.network.ResponseHandler;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseHandlingInputStream
extends FilterInputStream {
    private static final Logger logger = LoggerFactory.getLogger(ResponseHandlingInputStream.class);
    private static final int BUFFER_SIZE = 1024;
    private final String mRequestId;
    private final OutputStream mOutputStream;
    private final @Nullable CountingOutputStream mDecompressedCounter;
    private final ResponseHandler mResponseHandler;
    private @GuardedBy(value={"this"}) boolean mClosed;
    private @GuardedBy(value={"this"}) boolean mEofSeen;
    private @Nullable @GuardedBy(value={"this"}) byte[] mSkipBuffer;
    private long mLastDecompressedCount = 0L;

    public ResponseHandlingInputStream(InputStream inputStream, String requestId, OutputStream outputStream, @Nullable CountingOutputStream decompressedCounter, ResponseHandler responseHandler) {
        super(inputStream);
        this.mRequestId = requestId;
        this.mOutputStream = outputStream;
        this.mDecompressedCounter = decompressedCounter;
        this.mResponseHandler = responseHandler;
        this.mClosed = false;
    }

    private synchronized int checkEOF(int n) {
        if (n == -1) {
            this.closeOutputStreamQuietly();
            this.mResponseHandler.onEOF();
            this.mEofSeen = true;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        try {
            int result = this.checkEOF(this.in.read());
            if (result != -1) {
                this.mResponseHandler.onRead(1);
                this.writeToOutputStream(result);
            }
            return result;
        }
        catch (IOException ex) {
            throw this.handleIOException(ex);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int result = this.checkEOF(this.in.read(b, off, len));
            if (result != -1) {
                this.mResponseHandler.onRead(result);
                this.writeToOutputStream(b, off, result);
            }
            return result;
        }
        catch (IOException ex) {
            throw this.handleIOException(ex);
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long bytesDiff;
        int bytesToRead;
        long total;
        int result;
        byte[] buffer = this.getSkipBufferLocked();
        for (total = 0L; total < n && (result = this.read(buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, bytesDiff = n - total))) != -1; total += (long)result) {
        }
        return total;
    }

    private @NonNull byte[] getSkipBufferLocked() {
        if (this.mSkipBuffer == null) {
            this.mSkipBuffer = new byte[1024];
        }
        return this.mSkipBuffer;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("Mark not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            long bytesRead = 0L;
            if (!this.mEofSeen) {
                int count;
                byte[] buffer = new byte[1024];
                while ((count = this.read(buffer)) != -1) {
                    bytesRead += (long)count;
                }
            }
        }
        finally {
            super.close();
            this.closeOutputStreamQuietly();
        }
    }

    private synchronized void closeOutputStreamQuietly() {
        if (!this.mClosed) {
            try {
                this.mOutputStream.close();
                this.reportDecodedSizeIfApplicable();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mClosed = true;
            }
        }
    }

    private IOException handleIOException(IOException ex) {
        this.mResponseHandler.onError(ex);
        return ex;
    }

    private void reportDecodedSizeIfApplicable() {
        if (this.mDecompressedCounter != null) {
            long currentCount = this.mDecompressedCounter.getCount();
            int delta = (int)(currentCount - this.mLastDecompressedCount);
            this.mResponseHandler.onReadDecoded(delta);
            this.mLastDecompressedCount = currentCount;
        }
    }

    private synchronized void writeToOutputStream(int oneByte) {
        if (this.mClosed) {
            return;
        }
        try {
            this.mOutputStream.write(oneByte);
            this.reportDecodedSizeIfApplicable();
        }
        catch (IOException e) {
            this.handleIOExceptionWritingToStream(e);
        }
    }

    private synchronized void writeToOutputStream(byte[] b, int offset, int count) {
        if (this.mClosed) {
            return;
        }
        try {
            this.mOutputStream.write(b, offset, count);
            this.reportDecodedSizeIfApplicable();
        }
        catch (IOException e) {
            this.handleIOExceptionWritingToStream(e);
        }
    }

    private void handleIOExceptionWritingToStream(IOException e) {
        logger.debug("Could not write response body to the stream " + e);
        this.closeOutputStreamQuietly();
    }
}

