/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.helpers;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.validator.routines.InetAddressValidator;

public class NetUtils {
    private static final InetAddressValidator v = new InetAddressValidator();

    public static String getIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                String ip = NetUtils.parseInterface(intf, useIPv4);
                if (null == ip) continue;
                return ip;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String parseInterface(NetworkInterface netIntf, boolean useIPv4) {
        for (InetAddress addr : Collections.list(netIntf.getInetAddresses())) {
            String ip;
            if (addr.isLoopbackAddress() || null == (ip = NetUtils.parseAddr(addr, useIPv4))) continue;
            return ip;
        }
        return null;
    }

    private static String parseAddr(InetAddress addr, boolean useIPv4) {
        if (null == addr) {
            return null;
        }
        String ip = null;
        String sAddr = addr.getHostAddress();
        boolean isIPv4 = v.isValidInet4Address(sAddr);
        if (useIPv4 && isIPv4) {
            ip = sAddr;
        } else if (!useIPv4 && !isIPv4) {
            ip = NetUtils.ipv6DropZoneSuffixToUppercase(sAddr);
        }
        if (null != ip && !addr.isSiteLocalAddress()) {
            return ip;
        }
        return null;
    }

    public static String ipv6DropZoneSuffixToUppercase(String sAddr) {
        int delim = sAddr.indexOf(37);
        return delim < 0 ? sAddr.toUpperCase() : sAddr.substring(0, delim).toUpperCase();
    }
}

