/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.sdk.okhttp3client;

import com.moesif.api.models.EventRequestModel;
import com.moesif.api.models.EventResponseModel;
import com.moesif.external.facebook.stetho.inspector.network.NetworkEventReporterMoesif;
import com.moesif.external.facebook.stetho.inspector.network.NetworkEventReporterMoesifImpl;
import com.moesif.sdk.okhttp3client.MoesifResponseHandler;
import com.moesif.sdk.okhttp3client.config.MoesifApiConnConfig;
import com.moesif.sdk.okhttp3client.models.OkHttp3RequestMapper;
import com.moesif.sdk.okhttp3client.models.OkHttp3ResponseMapper;
import com.moesif.sdk.okhttp3client.models.filter.IInterceptEventFilter;
import com.moesif.sdk.okhttp3client.util.ResponseWrap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoesifOkHttp3Interceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MoesifOkHttp3Interceptor.class);
    private final NetworkEventReporterMoesif mEventReporter = NetworkEventReporterMoesifImpl.get();
    private final AtomicInteger mNextRequestId = new AtomicInteger(0);
    private static MoesifApiConnConfig connConfig;

    public MoesifOkHttp3Interceptor() {
        this.init(null);
    }

    public MoesifOkHttp3Interceptor(String moesifApplicationId) {
        this.init(new MoesifApiConnConfig(moesifApplicationId));
    }

    public MoesifOkHttp3Interceptor(String moesifApplicationId, Integer eventsBufferSize) {
        MoesifApiConnConfig c = new MoesifApiConnConfig(moesifApplicationId);
        c.setEventsBufferSize(eventsBufferSize);
        this.init(c);
    }

    public MoesifOkHttp3Interceptor(Integer eventsBufferSize) {
        MoesifApiConnConfig c = new MoesifApiConnConfig(null);
        c.setEventsBufferSize(eventsBufferSize);
        this.init(c);
    }

    public MoesifOkHttp3Interceptor(MoesifApiConnConfig connConfig) {
        this.init(connConfig);
    }

    public void init(MoesifApiConnConfig connConfig) {
        MoesifOkHttp3Interceptor.connConfig = null == connConfig ? new MoesifApiConnConfig() : connConfig;
    }

    public MoesifApiConnConfig getConnConfig() {
        return connConfig;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Instant utcInstance;
        Response response;
        String requestId = String.valueOf(this.mNextRequestId.getAndIncrement());
        Request request = chain.request();
        try {
            response = chain.proceed(request);
        }
        catch (IOException e) {
            logger.warn("IOException in chain cannot proceed", (Object)e.getMessage());
            throw e;
        }
        if (connConfig.getEventFilterConfig().skip(request, response)) {
            return response;
        }
        Date requestDate = null;
        Date responseDate = null;
        try {
            utcInstance = Instant.ofEpochMilli(response.sentRequestAtMillis());
            requestDate = Date.from(utcInstance);
        }
        catch (Exception e) {
            requestDate = new Date();
        }
        try {
            utcInstance = Instant.ofEpochMilli(response.receivedResponseAtMillis());
            responseDate = Date.from(utcInstance);
        }
        catch (Exception e) {
            responseDate = new Date();
        }
        IInterceptEventFilter filter = connConfig.getEventFilterConfig();
        EventRequestModel loggedRequest = OkHttp3RequestMapper.createOkHttp3Request(request, requestDate, filter.getApiVersion(request, response).orElse(null), connConfig.getBaseUri(), connConfig.getMaxAllowedBodyBytesRequest());
        Connection connection = chain.connection();
        ResponseWrap respw = new ResponseWrap(response);
        EventResponseModel loggedResponse = OkHttp3ResponseMapper.createOkHttp3Response(response, responseDate, connection);
        if (!respw.hasNullBody().booleanValue()) {
            try {
                ByteArrayOutputStream outputStream = MoesifOkHttp3Interceptor.genBAOutputStream(respw);
                MoesifResponseHandler moeRespHandler = new MoesifResponseHandler(loggedRequest, loggedResponse, outputStream, respw.isJsonHeader(), connConfig.getApplicationId(), connConfig.getMaxAllowedBodyBytesResponse(), connConfig.getEventsBufferSize(), filter.identifyUser(request, response).orElse(null), filter.identifyCompany(request, response).orElse(null), filter.sessionToken(request, response).orElse(null), filter.getMetadata(request, response), connConfig.getEventFilterConfig());
                InputStream responseStream = this.mEventReporter.interpretResponseStream(requestId, respw.getBodyContentType(), respw.getContentEncoding(), MoesifOkHttp3Interceptor.genBodyByteIS(respw, connConfig), moeRespHandler, outputStream);
                if (responseStream != null) {
                    response = response.newBuilder().body((ResponseBody)new ForwardingResponseBody(response.body(), responseStream)).build();
                }
            }
            catch (Exception e) {
                logger.warn("Error parsing response body", (Throwable)e);
            }
        } else {
            logger.warn("Body is null");
        }
        return response;
    }

    private static ByteArrayOutputStream genBAOutputStream(ResponseWrap respw) {
        int outStreamSize = (int)respw.getBodyContentLength();
        return outStreamSize > 0 ? new ByteArrayOutputStream(outStreamSize) : new ByteArrayOutputStream();
    }

    private static InputStream genBodyByteIS(ResponseWrap respw, MoesifApiConnConfig connConfig) {
        return MoesifOkHttp3Interceptor.isAllowedContentType(respw.getBodyContentType(), connConfig.getBodyContentTypesBlackList()) ? respw.getBodyByteInputStream() : null;
    }

    public static boolean isAllowedContentType(String cTypeToCheck, Collection<String> blockedContentTypes) {
        return StringUtils.isBlank((CharSequence)cTypeToCheck) || CollectionUtils.isEmpty(blockedContentTypes) || !blockedContentTypes.contains(cTypeToCheck.toLowerCase());
    }

    private static class ForwardingResponseBody
    extends ResponseBody {
        private final ResponseBody mBody;
        private final BufferedSource mInterceptedSource;

        public ForwardingResponseBody(ResponseBody body, InputStream interceptedStream) {
            this.mBody = body;
            this.mInterceptedSource = Okio.buffer((Source)Okio.source((InputStream)interceptedStream));
        }

        public MediaType contentType() {
            return this.mBody.contentType();
        }

        public long contentLength() {
            return this.mBody.contentLength();
        }

        public BufferedSource source() {
            return this.mInterceptedSource;
        }
    }
}

