/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.sdk.okhttp3client.config;

import com.moesif.sdk.okhttp3client.config.DefaultDomainData;
import com.moesif.sdk.okhttp3client.config.EnvironmentVars;
import com.moesif.sdk.okhttp3client.models.filter.DefaultEventFilterConfig;
import com.moesif.sdk.okhttp3client.models.filter.IInterceptEventFilter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MoesifApiConnConfig {
    public static String DEFAULT_BASE_URI = "https://api.moesif.net";
    public String baseUri;
    public Integer eventsBufferSize = 5;
    private IInterceptEventFilter eventFilterConfig;
    public Collection<String> bodyContentTypesBlackList = DefaultDomainData.bodyContentTypesBlackList;
    private String applicationId;

    public MoesifApiConnConfig() {
        this.init(null, null);
    }

    public MoesifApiConnConfig(String moesifApplicationId) {
        this.init(moesifApplicationId, null);
    }

    public MoesifApiConnConfig(String applicationId, String baseUri) {
        this.init(applicationId, baseUri);
    }

    public void init(String applicationId, String baseUri) {
        this.setBaseUri(baseUri);
        this.setApplicationId(applicationId);
        this.setEventFilterConfig(null);
    }

    public String getBaseUri() {
        Validate.notBlank((CharSequence)this.baseUri, (String)"BaseUrl not set", (Object[])new Object[0]);
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = MoesifApiConnConfig.getOrBlank(baseUri, EnvironmentVars.loadBaseUri(), DEFAULT_BASE_URI);
    }

    public Collection<String> getBodyContentTypesBlackList() {
        return this.bodyContentTypesBlackList;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = MoesifApiConnConfig.getOrBlank(applicationId, EnvironmentVars.loadMoesifApplicationId(), "");
    }

    private static String getOrBlank(String valPri1, String valPri2, String defVal) {
        return (String)StringUtils.defaultIfBlank((CharSequence)MoesifApiConnConfig.cleanAppId(valPri1), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)MoesifApiConnConfig.cleanAppId(valPri2), (CharSequence)MoesifApiConnConfig.cleanAppId(defVal))));
    }

    public static String cleanAppId(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            s = StringUtils.deleteWhitespace((String)s);
            for (char ch : Arrays.asList(Character.valueOf('\"'), Character.valueOf('\''))) {
                s = StringUtils.remove((String)s, (char)ch);
            }
        }
        return s;
    }

    public Long getMaxAllowedBodyBytesRequest() {
        return DefaultDomainData.maxAllowedBodyBytesRequest;
    }

    public Long getMaxAllowedBodyBytesResponse() {
        return DefaultDomainData.maxAllowedBodyBytesResponse;
    }

    public Integer getEventsBufferSize() {
        return this.eventsBufferSize;
    }

    public void setEventsBufferSize(Integer eventsBufferSize) {
        this.eventsBufferSize = Math.max(eventsBufferSize, 1);
    }

    public IInterceptEventFilter getEventFilterConfig() {
        return this.eventFilterConfig;
    }

    public void setEventFilterConfig(IInterceptEventFilter eventFilterConfig) {
        this.eventFilterConfig = null == eventFilterConfig ? new DefaultEventFilterConfig() : eventFilterConfig;
    }
}

