/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.sdk.okhttp3client.models;

import com.moesif.api.models.EventRequestBuilder;
import com.moesif.api.models.EventRequestModel;
import com.moesif.external.facebook.stetho.inspector.network.RequestBodyHelperMoesif;
import com.moesif.helpers.CollectionUtils;
import com.moesif.helpers.NetUtils;
import com.moesif.sdk.okhttp3client.util.JsonSerialize;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OkHttp3RequestMapper
extends EventRequestModel {
    public static EventRequestModel createOkHttp3Request(Request request, Date requestDate, String apiVersion, String ipAddress, Long maxAllowedBodyBytesRequest) throws IOException {
        if (StringUtils.isBlank((CharSequence)ipAddress)) {
            ipAddress = NetUtils.getIPAddress(true);
        }
        EventRequestBuilder erb = new EventRequestBuilder().time(requestDate).uri(request.url().toString()).verb(request.method()).apiVersion(apiVersion).ipAddress(ipAddress).headers(CollectionUtils.flattenMultiMap(request.headers().toMultimap()));
        if (OkHttp3RequestMapper.isBodyContentLenAcceptable(request, maxAllowedBodyBytesRequest)) {
            erb.body(OkHttp3RequestMapper.bodyAsJson(request));
        }
        return erb.build();
    }

    private static boolean isBodyContentLenAcceptable(Request request, Long maxAllowedBodyBytesReq) throws IOException {
        if (null == maxAllowedBodyBytesReq) {
            return true;
        }
        if (maxAllowedBodyBytesReq > 0L && request != null && request.body() != null) {
            return request.body().contentLength() <= maxAllowedBodyBytesReq;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @Nullable Object bodyAsJson(Request request) throws IOException {
        RequestBody body = request.body();
        if (body == null || body.contentLength() == 0L) {
            return null;
        }
        RequestBodyHelperMoesif rbh = new RequestBodyHelperMoesif();
        OutputStream out = rbh.createBodySink(request.header("Content-Encoding"));
        try (BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)out));){
            body.writeTo(bufferedSink);
        }
        return JsonSerialize.jsonBAOutStreamToObj(rbh.getDisplayBody());
    }
}

