/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.sdk.okhttp3client.models;

import com.moesif.api.models.EventResponseBuilder;
import com.moesif.api.models.EventResponseModel;
import com.moesif.helpers.CollectionUtils;
import java.util.Date;
import okhttp3.Connection;
import okhttp3.Response;

public class OkHttp3ResponseMapper
extends EventResponseModel {
    public static EventResponseModel createOkHttp3Response(Response response, Date responseDate, Connection connection) {
        String ipAddress = OkHttp3ResponseMapper.getIpAddr(connection);
        return OkHttp3ResponseMapper.createOkHttp3Response(response, responseDate, ipAddress);
    }

    public static EventResponseModel createOkHttp3Response(Response response, Date responseDate, String ipAddress) {
        return new EventResponseBuilder().time(responseDate).status(response.code()).headers(CollectionUtils.flattenMultiMap(response.headers().toMultimap())).ipAddress(ipAddress).build();
    }

    public static String getIpAddr(Connection c) {
        String ipAddress = null;
        if (c != null) {
            ipAddress = c.route().socketAddress().getAddress().getHostAddress();
        }
        return ipAddress;
    }
}

