/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.servlet;

import com.moesif.api.MoesifAPIClient;
import com.moesif.api.controllers.APIController;
import com.moesif.api.http.response.HttpResponse;
import com.moesif.api.models.AppConfigModel;
import java.io.InputStream;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Logger;

public class AppConfigManager
extends TimerTask {
    private static final Logger logger = Logger.getLogger(AppConfigManager.class.toString());
    private static AppConfigManager instance = null;
    private MoesifAPIClient moesifApi = null;
    private AppConfigModel appConfigModel = new AppConfigModel();
    private String cachedConfigEtag;
    private Date lastUpdatedTime = new Date(0L);
    private boolean jobRunning = false;
    private boolean debug = false;

    public boolean isJobRunning() {
        return this.jobRunning;
    }

    public static synchronized AppConfigManager getInstance() {
        if (instance == null) {
            instance = new AppConfigManager();
        }
        return instance;
    }

    public void setMoesifApiClient(MoesifAPIClient moesifApi, boolean debug) {
        this.moesifApi = moesifApi;
        this.debug = debug;
    }

    private AppConfigManager() {
    }

    public int getSampleRate(String userId, String companyId) {
        int sampleRate = this.appConfigModel.getSampleRate();
        if (userId != null && this.appConfigModel.getUserSampleRate().containsKey(userId)) {
            sampleRate = (Integer)this.appConfigModel.getUserSampleRate().get(userId);
        } else if (companyId != null && this.appConfigModel.getCompanySampleRate().containsKey(companyId)) {
            sampleRate = (Integer)this.appConfigModel.getCompanySampleRate().get(companyId);
        }
        return sampleRate;
    }

    public void updateIfStale(String responseConfigEtag) {
        if (this.isJobRunning()) {
            return;
        }
        if (responseConfigEtag != null && !responseConfigEtag.equals(this.cachedConfigEtag) && new Date().after(new Date(this.lastUpdatedTime.getTime() + 300000L))) {
            if (this.debug) {
                logger.info("Calling API to update appConfig based on Etag.");
            }
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isJobRunning()) {
            return;
        }
        try {
            this.jobRunning = true;
            HttpResponse configApiResponse = this.moesifApi.getAPI().getAppConfig();
            String responseConfigEtag = (String)configApiResponse.getHeaders().get("x-moesif-config-etag");
            InputStream respBodyIs = configApiResponse.getRawBody();
            AppConfigModel newConfig = APIController.parseAppConfigModel((InputStream)respBodyIs);
            respBodyIs.close();
            this.appConfigModel = newConfig;
            this.cachedConfigEtag = responseConfigEtag;
        }
        catch (Throwable e) {
            logger.warning("Fetched configuration failed; using default configuration " + e.toString());
            this.appConfigModel = new AppConfigModel();
            this.appConfigModel.setSampleRate(100);
        }
        finally {
            this.jobRunning = false;
        }
        this.lastUpdatedTime = new Date();
    }
}

