/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.servlet;

import com.moesif.api.MoesifAPIClient;
import com.moesif.api.http.client.APICallBack;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.http.response.HttpResponse;
import com.moesif.api.models.EventModel;
import com.moesif.servlet.AppConfigManager;
import com.moesif.servlet.MoesifConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class BatchProcessor
extends TimerTask {
    private static final Logger logger = Logger.getLogger(BatchProcessor.class.toString());
    private final MoesifConfiguration moesifConfig;
    private final MoesifAPIClient moesifApi;
    private final Boolean debug;
    private final BlockingQueue<EventModel> batchQueue;
    private boolean jobRunning = false;

    public BatchProcessor(MoesifAPIClient moesifApi, MoesifConfiguration moesifConfig, boolean debug) {
        this.moesifApi = moesifApi;
        this.moesifConfig = moesifConfig;
        this.debug = debug;
        this.batchQueue = new ArrayBlockingQueue<EventModel>(this.moesifConfig.queueSize);
    }

    public int getBatchMaxTime() {
        return this.moesifConfig.batchMaxTime;
    }

    public int getUpdateConfigTime() {
        return this.moesifConfig.updateConfigTime;
    }

    public void addEvent(EventModel event) {
        try {
            this.batchQueue.put(event);
            if (this.debug.booleanValue()) {
                String msg = String.format("Event successfully added to queue. Queue Size = %d", this.batchQueue.size());
                logger.info(msg);
            }
        }
        catch (Exception e) {
            logger.warning("Add event failed. " + e);
        }
    }

    public boolean isJobRunning() {
        return this.jobRunning;
    }

    private void sendBatch(List<EventModel> curEventList) {
        final boolean[] done = new boolean[]{false};
        int retry = 0;
        APICallBack<HttpResponse> callBack = new APICallBack<HttpResponse>(){

            public void onSuccess(HttpContext httpContext, HttpResponse httpResponse) {
                int status = httpContext.getResponse().getStatusCode();
                done[0] = true;
                if (status == 201) {
                    String responseConfigEtag = (String)httpResponse.getHeaders().get("x-moesif-config-etag");
                    if (responseConfigEtag != null) {
                        AppConfigManager.getInstance().updateIfStale(responseConfigEtag);
                    }
                } else if (BatchProcessor.this.debug.booleanValue()) {
                    logger.warning("Status is " + status);
                }
            }

            public void onFailure(HttpContext httpContext, Throwable error) {
                int status = httpContext.getResponse().getStatusCode();
                if (error != null) {
                    if (error instanceof TimeoutException || status == 500) {
                        done[0] = false;
                    } else {
                        done[0] = true;
                        if (BatchProcessor.this.debug.booleanValue()) {
                            String msg = String.format("send to Moesif error. %s", error);
                            logger.warning(msg);
                        }
                    }
                }
            }
        };
        do {
            try {
                ++retry;
                this.moesifApi.getAPI().createEventsBatchAsync(curEventList, (APICallBack)callBack);
            }
            catch (Exception e) {
                logger.warning("Failed to send batch events. " + e);
            }
        } while (!done[0] && retry < this.moesifConfig.retry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.jobRunning = true;
        if (this.batchQueue.isEmpty()) {
            if (this.debug.booleanValue()) {
                logger.info("No events to send.");
            }
            this.jobRunning = false;
            return;
        }
        try {
            ArrayList allEventList = new ArrayList();
            this.batchQueue.drainTo(allEventList);
            int batchCount = 0;
            int i = 0;
            while (i < allEventList.size()) {
                int endIndex = Math.min(allEventList.size(), i + this.moesifConfig.batchSize);
                List<EventModel> curEventList = allEventList.subList(i, endIndex);
                this.sendBatch(curEventList);
                i += this.moesifConfig.batchSize;
                ++batchCount;
            }
            if (this.debug.booleanValue()) {
                String msg = String.format("%d Batch of events successfully sent to Moesif. Total events count = %d", batchCount, allEventList.size());
                logger.info(msg);
            }
        }
        catch (Throwable e) {
            logger.warning(e.toString());
        }
        finally {
            this.jobRunning = false;
        }
    }
}

