/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.servlet;

import com.moesif.api.BodyParser;
import com.moesif.api.IpAddress;
import com.moesif.api.MoesifAPIClient;
import com.moesif.api.controllers.APIController;
import com.moesif.api.http.client.APICallBack;
import com.moesif.api.http.client.HttpContext;
import com.moesif.api.models.CompanyModel;
import com.moesif.api.models.EventBuilder;
import com.moesif.api.models.EventModel;
import com.moesif.api.models.EventRequestBuilder;
import com.moesif.api.models.EventRequestModel;
import com.moesif.api.models.EventResponseBuilder;
import com.moesif.api.models.EventResponseModel;
import com.moesif.api.models.UserModel;
import com.moesif.servlet.AppConfigManager;
import com.moesif.servlet.BatchProcessor;
import com.moesif.servlet.MoesifConfiguration;
import com.moesif.servlet.MoesifConfigurationAdapter;
import com.moesif.servlet.wrappers.LoggingHttpServletRequestWrapper;
import com.moesif.servlet.wrappers.LoggingHttpServletResponseWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class MoesifFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(MoesifFilter.class.toString());
    private String applicationId;
    private MoesifConfiguration config;
    private MoesifAPIClient moesifApi;
    private boolean debug;
    private boolean logBody;
    private BatchProcessor batchProcessor = null;
    private int sendBatchJobAliveCounter = 0;
    Timer updateConfigTimer = null;
    Timer sendBatchEventTimer = null;

    public MoesifFilter() {
        this.setDebug(false);
        this.setLogBody(true);
        this.setConfigure(new MoesifConfigurationAdapter());
    }

    public MoesifFilter(String applicationId) {
        this.setDebug(false);
        this.setLogBody(true);
        this.setConfigure(new MoesifConfigurationAdapter());
        this.setApplicationId(applicationId);
    }

    public MoesifFilter(String applicationId, boolean debug) {
        this.setDebug(debug);
        this.setLogBody(true);
        this.setConfigure(new MoesifConfigurationAdapter());
        this.setApplicationId(applicationId);
    }

    public MoesifFilter(String applicationId, MoesifConfiguration config) {
        this.setDebug(false);
        this.setLogBody(true);
        this.setConfigure(config);
        this.setApplicationId(applicationId);
    }

    public MoesifFilter(String applicationId, MoesifConfiguration config, boolean debug) {
        this.setDebug(debug);
        this.setLogBody(true);
        this.setConfigure(config);
        this.setApplicationId(applicationId);
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        this.createMoesifApiClient();
    }

    private void createMoesifApiClient() {
        this.moesifApi = new MoesifAPIClient(this.applicationId);
    }

    public void setConfigure(MoesifConfiguration config) {
        this.config = config;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLogBody(boolean logBody) {
        this.logBody = logBody;
    }

    public APIController getAPI() {
        if (this.moesifApi != null) {
            return this.moesifApi.getAPI();
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String logBody;
        String debug;
        logger.info("Initialized Moesif filter");
        String appId = filterConfig.getInitParameter("application-id");
        if (appId != null) {
            this.setApplicationId(appId);
        }
        if ((debug = filterConfig.getInitParameter("debug")) != null && debug.equals("true")) {
            this.setDebug(true);
        }
        if ((logBody = filterConfig.getInitParameter("logBody")) != null && logBody.equals("false")) {
            this.setLogBody(false);
        }
        AppConfigManager.getInstance().setMoesifApiClient(this.moesifApi, this.debug);
        AppConfigManager.getInstance().run();
        this.initBatchProcessorAndStartJobs();
    }

    public void destroy() {
        this.drainQueueAndStopJobs();
        if (this.debug) {
            logger.info("Destroyed Moesif filter");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateUser(UserModel userModel) throws Throwable {
        if (this.moesifApi != null) {
            String userId = userModel.getUserId();
            if (userId == null || userId.isEmpty()) throw new IllegalArgumentException("To update an user, an userId field is required");
            try {
                this.moesifApi.getAPI().updateUser(userModel);
                return;
            }
            catch (Exception e) {
                if (!this.debug) return;
                logger.warning("Update User to Moesif failed " + e.toString());
            }
            return;
        } else {
            logger.warning("The application Id should be set before using MoesifFilter");
        }
    }

    public void updateUsersBatch(List<UserModel> usersModel) throws Throwable {
        block7: {
            ArrayList<UserModel> users = new ArrayList<UserModel>();
            if (this.moesifApi != null) {
                for (UserModel user : usersModel) {
                    String userId = user.getUserId();
                    if (userId != null && !userId.isEmpty()) {
                        users.add(user);
                        continue;
                    }
                    throw new IllegalArgumentException("To update an user, an userId field is required");
                }
            } else {
                logger.warning("The application Id should be set before using MoesifFilter");
            }
            if (!users.isEmpty()) {
                try {
                    this.moesifApi.getAPI().updateUsersBatch(users);
                }
                catch (Exception e) {
                    if (!this.debug) break block7;
                    logger.warning("Update User to Moesif failed " + e.toString());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCompany(CompanyModel companyModel) throws Throwable {
        if (this.moesifApi != null) {
            String companyId = companyModel.getCompanyId();
            if (companyId == null || companyId.isEmpty()) throw new IllegalArgumentException("To update a company, a companyId field is required");
            try {
                this.moesifApi.getAPI().updateCompany(companyModel);
                return;
            }
            catch (Exception e) {
                if (!this.debug) return;
                logger.warning("Update Company to Moesif failed " + e.toString());
            }
            return;
        } else {
            logger.warning("The application Id should be set before using MoesifFilter");
        }
    }

    public void updateCompaniesBatch(List<CompanyModel> companiesModel) throws Throwable {
        block7: {
            ArrayList<CompanyModel> companies = new ArrayList<CompanyModel>();
            if (this.moesifApi != null) {
                for (CompanyModel company : companiesModel) {
                    String companyId = company.getCompanyId();
                    if (companyId != null && !companyId.isEmpty()) {
                        companies.add(company);
                        continue;
                    }
                    throw new IllegalArgumentException("To update a company, a companyId field is required");
                }
            } else {
                logger.warning("The application Id should be set before using MoesifFilter");
            }
            if (!companies.isEmpty()) {
                try {
                    this.moesifApi.getAPI().updateCompaniesBatch(companies);
                }
                catch (Exception e) {
                    if (!this.debug) break block7;
                    logger.warning("Update Companies to Moesif failed " + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.debug) {
            logger.info("filtering request");
        }
        Date startDate = new Date();
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            logger.warning("MoesifFilter was called for non HTTP requests");
            filterChain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.config.skip(httpRequest, httpResponse)) {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            if (this.debug) {
                logger.warning("skipping request");
            }
            return;
        }
        LoggingHttpServletRequestWrapper requestWrapper = new LoggingHttpServletRequestWrapper(httpRequest);
        LoggingHttpServletResponseWrapper responseWrapper = new LoggingHttpServletResponseWrapper(httpResponse);
        String transactionId = null;
        if (!this.config.disableTransactionId) {
            String reqTransId = requestWrapper.getHeader("X-Moesif-Transaction-Id");
            transactionId = reqTransId != null && !reqTransId.isEmpty() ? reqTransId : UUID.randomUUID().toString();
            responseWrapper.addHeader("X-Moesif-Transaction-Id", transactionId);
        }
        EventRequestModel eventRequestModel = this.getEventRequestModel(requestWrapper, startDate, this.config.getApiVersion(httpRequest, httpResponse), transactionId);
        try {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        finally {
            Date endDate = new Date();
            EventResponseModel eventResponseModel = this.getEventResponseModel(responseWrapper, endDate);
            if (!(responseWrapper.getResponse() instanceof LoggingHttpServletResponseWrapper)) {
                this.sendEvent(eventRequestModel, eventResponseModel, this.config.identifyUser(httpRequest, httpResponse), this.config.identifyCompany(httpRequest, httpResponse), this.config.getSessionToken(httpRequest, httpResponse), this.config.getTags(httpRequest, httpResponse), this.config.getMetadata(httpRequest, httpResponse));
            }
        }
    }

    private EventRequestModel getEventRequestModel(LoggingHttpServletRequestWrapper requestWrapper, Date date, String apiVersion, String transactionId) {
        EventRequestBuilder eventRequestBuilder = new EventRequestBuilder();
        Map<Object, Object> reqHeaders = new HashMap(0);
        reqHeaders = transactionId != null ? requestWrapper.addHeader("X-Moesif-Transaction-Id", transactionId) : requestWrapper.getHeaders();
        eventRequestBuilder.time(date).uri(MoesifFilter.getFullURL((HttpServletRequest)requestWrapper)).headers(reqHeaders).verb(requestWrapper.getMethod()).ipAddress(IpAddress.getClientIp(requestWrapper.getHeaders(), (String)requestWrapper.getRemoteAddr()));
        if (StringUtils.isNotEmpty((CharSequence)apiVersion)) {
            eventRequestBuilder.apiVersion(apiVersion);
        }
        String content = requestWrapper.getContent();
        if (this.logBody && content != null && !content.isEmpty()) {
            BodyParser.BodyWrapper bodyWrapper = BodyParser.parseBody(requestWrapper.getHeaders(), (String)content);
            eventRequestBuilder.body(bodyWrapper.body);
            eventRequestBuilder.transferEncoding(bodyWrapper.transferEncoding);
        }
        return eventRequestBuilder.build();
    }

    private EventResponseModel getEventResponseModel(LoggingHttpServletResponseWrapper responseWrapper, Date date) {
        EventResponseBuilder eventResponseBuilder = new EventResponseBuilder();
        eventResponseBuilder.time(date).status(responseWrapper.getStatus()).headers(responseWrapper.getHeaders());
        String content = responseWrapper.getContent();
        if (this.logBody && content != null && !content.isEmpty()) {
            BodyParser.BodyWrapper bodyWrapper = BodyParser.parseBody(responseWrapper.getHeaders(), (String)content);
            eventResponseBuilder.body(bodyWrapper.body);
            eventResponseBuilder.transferEncoding(bodyWrapper.transferEncoding);
        }
        return eventResponseBuilder.build();
    }

    private void initBatchProcessorAndStartJobs() {
        this.batchProcessor = new BatchProcessor(this.moesifApi, this.config, this.debug);
        this.scheduleAppConfigJob();
        this.scheduleBatchEventsJob();
    }

    public void drainQueueAndStopJobs() {
        this.batchProcessor.run();
        try {
            if (this.debug) {
                logger.info("Stopping scheduled jobs.");
            }
            this.resetJobTimer(this.updateConfigTimer);
            this.resetJobTimer(this.sendBatchEventTimer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void scheduleAppConfigJob() {
        this.resetJobTimer(this.updateConfigTimer);
        this.updateConfigTimer = new Timer("moesif_update_config_job");
        this.updateConfigTimer.schedule((TimerTask)AppConfigManager.getInstance(), (long)this.batchProcessor.getUpdateConfigTime() * 1000L, (long)this.batchProcessor.getUpdateConfigTime() * 1000L);
    }

    private void scheduleBatchEventsJob() {
        this.resetJobTimer(this.sendBatchEventTimer);
        this.sendBatchEventTimer = new Timer("moesif_events_batch_job");
        this.sendBatchEventTimer.schedule((TimerTask)this.batchProcessor, 0L, (long)this.batchProcessor.getBatchMaxTime() * 1000L);
    }

    private void resetJobTimer(Timer timer) {
        if (timer != null) {
            timer.cancel();
            timer.purge();
            timer = null;
        }
    }

    private void rescheduleSendEventsJobIfNeeded() {
        String msg;
        if (this.batchProcessor.isJobRunning()) {
            if (this.debug) {
                String msg2 = String.format("Send event job is in-progress.", new Object[0]);
                logger.info(msg2);
            }
            return;
        }
        long MAX_TARDINESS_SEND_EVENT_JOB = this.config.batchMaxTime * 60;
        long diff = new Date().getTime() - this.batchProcessor.scheduledExecutionTime();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(diff);
        if (seconds > MAX_TARDINESS_SEND_EVENT_JOB) {
            if (this.debug) {
                msg = String.format("Last send batchEvents job was executed %d minutes ago. Rescheduling job..", seconds / 60L);
                logger.info(msg);
            }
            this.scheduleBatchEventsJob();
        }
        if (this.debug) {
            msg = String.format("Last send batchEvents job was executed %d seconds ago.", seconds);
            logger.info(msg);
        }
    }

    private void addEventToQueue(EventModel maskedEvent) {
        try {
            this.batchProcessor.addEvent(maskedEvent);
            ++this.sendBatchJobAliveCounter;
            if (this.sendBatchJobAliveCounter > 100) {
                if (this.debug) {
                    logger.info("Check for liveness of taskRunner.");
                }
                this.rescheduleSendEventsJobIfNeeded();
                this.sendBatchJobAliveCounter = 0;
            }
        }
        catch (Throwable e) {
            logger.warning("Failed to add event to the queue. " + e.toString());
        }
    }

    private void sendEvent(EventRequestModel eventRequestModel, EventResponseModel eventResponseModel, String userId, String companyId, String sessionToken, String tags, Object metadata) {
        block13: {
            EventBuilder eb = new EventBuilder();
            eb.request(eventRequestModel);
            eb.response(eventResponseModel);
            eb.direction("Incoming");
            if (userId != null) {
                eb.userId(userId);
            }
            if (companyId != null) {
                eb.companyId(companyId);
            }
            if (sessionToken != null) {
                eb.sessionToken(sessionToken);
            }
            if (tags != null) {
                eb.tags(tags);
            }
            if (metadata != null) {
                eb.metadata(metadata);
            }
            EventModel event = eb.build();
            if (this.moesifApi != null) {
                APICallBack<Object> callBack = new APICallBack<Object>(){

                    public void onSuccess(HttpContext context, Object response) {
                        if (MoesifFilter.this.debug) {
                            logger.info("send to Moesif success");
                        }
                    }

                    public void onFailure(HttpContext context, Throwable error) {
                        if (MoesifFilter.this.debug) {
                            logger.info("send to Moesif error ");
                            logger.info(error.toString());
                        }
                    }
                };
                try {
                    EventModel maskedEvent = this.config.maskContent(event);
                    if (maskedEvent == null) {
                        logger.severe("maskContent() returned a null object, not allowed");
                    }
                    double randomPercentage = Math.random() * 100.0;
                    int samplingPercentage = AppConfigManager.getInstance().getSampleRate(userId, companyId);
                    if ((double)samplingPercentage >= randomPercentage) {
                        maskedEvent.setWeight(this.moesifApi.getAPI().calculateWeight(samplingPercentage));
                        this.addEventToQueue(maskedEvent);
                    } else if (this.debug) {
                        logger.info("Skipped Event due to SamplingPercentage " + samplingPercentage + " and randomPercentage " + randomPercentage);
                    }
                    break block13;
                }
                catch (Throwable e) {
                    if (this.debug) {
                        logger.warning("add event to queue failed " + e);
                    }
                    break block13;
                }
            }
            logger.warning("The application Id should be set before using MoesifFilter");
        }
    }

    static String getFullURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (requestURL == null) {
            return "/";
        }
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }
}

