/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.servlet.wrappers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LoggingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final List<String> FORM_CONTENT_TYPE = Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data");
    private static final String METHOD_POST = "POST";
    private byte[] content;
    private final Map<String, String[]> parameterMap;
    private final HttpServletRequest delegate;

    public LoggingHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.delegate = request;
        this.parameterMap = this.isFormPost() ? request.getParameterMap() : Collections.emptyMap();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (ArrayUtils.isEmpty((byte[])this.content)) {
            return this.delegate.getInputStream();
        }
        return new LoggingServletInputStream(this.content);
    }

    public BufferedReader getReader() throws IOException {
        if (ArrayUtils.isEmpty((byte[])this.content)) {
            return this.delegate.getReader();
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getParameter(String name) {
        if (ArrayUtils.isEmpty((byte[])this.content) || this.parameterMap.isEmpty()) {
            return super.getParameter(name);
        }
        Object[] values = this.parameterMap.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return Arrays.toString(values);
    }

    public Map<String, String[]> getParameterMap() {
        if (ArrayUtils.isEmpty((byte[])this.content) || this.parameterMap.isEmpty()) {
            return super.getParameterMap();
        }
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        if (ArrayUtils.isEmpty((byte[])this.content) || this.parameterMap.isEmpty()) {
            return super.getParameterNames();
        }
        return new ParamNameEnumeration(this.parameterMap.keySet());
    }

    public String[] getParameterValues(String name) {
        if (ArrayUtils.isEmpty((byte[])this.content) || this.parameterMap.isEmpty()) {
            return super.getParameterValues(name);
        }
        return this.parameterMap.get(name);
    }

    public String getContent() {
        try {
            this.content = this.parameterMap.isEmpty() ? IOUtils.toByteArray((InputStream)this.delegate.getInputStream()) : this.getContentFromParameterMap(this.parameterMap);
            String requestEncoding = this.delegate.getCharacterEncoding();
            String normalizedContent = StringUtils.normalizeSpace((String)new String(this.content, requestEncoding != null ? requestEncoding : StandardCharsets.UTF_8.name()));
            return normalizedContent;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    private byte[] getContentFromParameterMap(Map<String, String[]> parameterMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String[]> e : parameterMap.entrySet()) {
            Object[] value = e.getValue();
            result.add(e.getKey() + "=" + (String)(value.length == 1 ? value[0] : Arrays.toString(value)));
        }
        return StringUtils.join(result, (String)"&").getBytes();
    }

    public Map<String, String> addHeader(String headerKey, String headerValue) {
        Map<Object, Object> headers = new HashMap(0);
        headers = this.getHeaders();
        headers.put(headerKey, headerValue);
        headers.remove("x-moesif-transaction-id");
        return headers;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(0);
        Enumeration headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName == null) continue;
            headers.put(headerName, StringUtils.join(Collections.list(this.getHeaders(headerName)), (String)","));
        }
        return headers;
    }

    public boolean isFormPost() {
        String contentType = this.getContentType();
        if (contentType != null && METHOD_POST.equalsIgnoreCase(this.getMethod())) {
            for (String formType : FORM_CONTENT_TYPE) {
                if (!contentType.toLowerCase().contains(formType)) continue;
                return true;
            }
        }
        return false;
    }

    private class LoggingServletInputStream
    extends ServletInputStream {
        private final InputStream is;

        private LoggingServletInputStream(byte[] content) {
            this.is = new ByteArrayInputStream(content);
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public void close() throws IOException {
            super.close();
            this.is.close();
        }
    }

    private class ParamNameEnumeration
    implements Enumeration<String> {
        private final Iterator<String> iterator;

        private ParamNameEnumeration(Set<String> values) {
            Iterator emptyIterator = Collections.emptyIterator();
            this.iterator = values != null ? values.iterator() : emptyIterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }
}

