/*
 * Decompiled with CFR 0.152.
 */
package com.moesif.servlet.wrappers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;

public class LoggingHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStream outputStream;
    private LoggingServletOutputStream logStream;
    private PrintWriter writer;

    public LoggingHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response.");
        }
        if (this.outputStream == null) {
            this.outputStream = this.getResponse().getOutputStream();
            this.logStream = new LoggingServletOutputStream(this.outputStream);
        }
        return this.logStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response.");
        }
        if (this.writer == null) {
            this.logStream = new LoggingServletOutputStream(this.getResponse().getOutputStream());
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.logStream), this.getResponse().getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.outputStream != null) {
            this.logStream.flush();
        }
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(0);
        Collection headerNames = this.getHeaderNames();
        for (String headerName : headerNames) {
            if (headerName == null) continue;
            if (headerName.equals("set-cookie")) {
                headers.put(headerName, this.getHeader(headerName));
                continue;
            }
            headers.put(headerName, StringUtils.join((Iterable)this.getHeaders(headerName), (String)","));
        }
        return headers;
    }

    public String getContent() {
        try {
            this.flushBuffer();
            if (this.logStream == null) {
                return null;
            }
            String responseEncoding = this.getResponse().getCharacterEncoding();
            return this.logStream.baos.toString(responseEncoding != null ? responseEncoding : StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "[UNSUPPORTED ENCODING]";
        }
        catch (IOException e) {
            return "[IO EXCEPTION]";
        }
    }

    private class LoggingServletOutputStream
    extends ServletOutputStream {
        private ServletOutputStream outputStream;
        private ByteArrayOutputStream baos;

        public LoggingServletOutputStream(ServletOutputStream outputStream) {
            this.outputStream = outputStream;
            this.baos = new ByteArrayOutputStream(1024);
        }

        public boolean isReady() {
            return this.outputStream.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.outputStream.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.baos.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
            this.baos.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
            this.baos.write(b, off, len);
        }

        public void flush() throws IOException {
            this.outputStream.flush();
            this.baos.flush();
        }

        public void close() throws IOException {
            this.outputStream.close();
            this.baos.close();
        }
    }
}

