/*
 * Copyright 2011 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.mogwee.executors;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Factory that sets the name of each thread it creates to {@code [name]-[id]}.
 * This makes debugging stack traces much easier.
 */
public class NamedThreadFactory implements ThreadFactory
{
    private final AtomicInteger count = new AtomicInteger(0);
    private final String name;

    public NamedThreadFactory(String name)
    {
        this.name = name;
    }

    @Override
    public Thread newThread(final Runnable runnable)
    {
        Thread thread = new Thread(runnable);

        thread.setName(name + "-" + count.incrementAndGet());

        return thread;
    }
}
