/*
 * Decompiled with CFR 0.152.
 */
package com.mogwee.executors;

import com.mogwee.executors.WrappedCallable;
import com.mogwee.executors.WrappedRunnable;
import com.mogwee.executors.WrappedRunnableFuture;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExecutor
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingExecutor.class);

    public LoggingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public LoggingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public LoggingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public LoggingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(WrappedCallable.wrap(LOG, task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        WrappedRunnable runnable = WrappedRunnable.wrap(LOG, task);
        Future<T> future = super.submit(runnable, result);
        return WrappedRunnableFuture.wrap(runnable, future);
    }

    @Override
    public Future<?> submit(Runnable task) {
        WrappedRunnable runnable = WrappedRunnable.wrap(LOG, task);
        Future<?> future = super.submit(runnable);
        return WrappedRunnableFuture.wrap(runnable, future);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(WrappedRunnable.wrap(LOG, command));
    }
}

