/*
 * Decompiled with CFR 0.152.
 */
package com.mogwee.executors;

import com.mogwee.executors.WrappedRunnable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class WrappedRunnableFuture<V>
implements Future<V> {
    private final WrappedRunnable runnable;
    private final Future<V> delegate;

    private WrappedRunnableFuture(WrappedRunnable runnable, Future<V> delegate) {
        this.runnable = runnable;
        this.delegate = delegate;
    }

    public static <V> WrappedRunnableFuture wrap(WrappedRunnable runnable, Future<V> delegate) {
        return new WrappedRunnableFuture<V>(runnable, delegate);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        V result = this.delegate.get();
        this.checkForException();
        return result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        V result = this.delegate.get(timeout, unit);
        this.checkForException();
        return result;
    }

    private void checkForException() throws InterruptedException, ExecutionException {
        Throwable exception = this.runnable.getException();
        if (exception != null) {
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            if (exception instanceof ExecutionException) {
                throw (ExecutionException)exception;
            }
            throw new ExecutionException(exception);
        }
    }
}

