/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.RedisURI;
import com.moilioncircle.redis.replicator.SslConfiguration;
import com.moilioncircle.redis.replicator.net.SslContextFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;

public class Configuration {
    private int connectionTimeout = 30000;
    private int readTimeout = 30000;
    private int receiveBufferSize = 0;
    private int sendBufferSize = 0;
    private int retries = 5;
    private int retryTimeInterval = 1000;
    private int bufferSize = 8192;
    private String authUser = null;
    private String authPassword = null;
    private boolean discardRdbEvent = false;
    private int asyncCachedBytes = 524288;
    private int rateLimit = 0;
    private boolean verbose = false;
    private int heartbeatPeriod = 1000;
    private boolean useDefaultExceptionListener = true;
    private boolean ssl = false;
    private SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private SslContextFactory sslContextFactory;
    private SSLParameters sslParameters;
    private HostnameVerifier hostnameVerifier;
    private String replId = "?";
    private int replStreamDB = -1;
    private final AtomicLong replOffset = new AtomicLong(-1L);

    private Configuration() {
    }

    public static Configuration defaultSetting() {
        return new Configuration();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Configuration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Configuration setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public int getRetries() {
        return this.retries;
    }

    public Configuration setRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public Configuration setAuthUser(String authUser) {
        this.authUser = authUser;
        return this;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public Configuration setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
        return this;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Configuration setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Configuration setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Configuration setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public boolean isDiscardRdbEvent() {
        return this.discardRdbEvent;
    }

    public Configuration setDiscardRdbEvent(boolean discardRdbEvent) {
        this.discardRdbEvent = discardRdbEvent;
        return this;
    }

    public String getReplId() {
        return this.replId;
    }

    public Configuration setReplId(String replId) {
        this.replId = replId;
        return this;
    }

    public int getReplStreamDB() {
        return this.replStreamDB;
    }

    public Configuration setReplStreamDB(int replStreamDB) {
        this.replStreamDB = replStreamDB;
        return this;
    }

    public long getReplOffset() {
        return this.replOffset.get();
    }

    public Configuration setReplOffset(long replOffset) {
        this.replOffset.set(replOffset);
        return this;
    }

    public Configuration addOffset(long offset) {
        this.replOffset.addAndGet(offset);
        return this;
    }

    public int getAsyncCachedBytes() {
        return this.asyncCachedBytes;
    }

    public Configuration setAsyncCachedBytes(int asyncCachedBytes) {
        this.asyncCachedBytes = asyncCachedBytes;
        return this;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public Configuration setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Configuration setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public Configuration setHeartbeatPeriod(int heartbeatPeriod) {
        this.heartbeatPeriod = heartbeatPeriod;
        return this;
    }

    public boolean isUseDefaultExceptionListener() {
        return this.useDefaultExceptionListener;
    }

    public Configuration setUseDefaultExceptionListener(boolean useDefaultExceptionListener) {
        this.useDefaultExceptionListener = useDefaultExceptionListener;
        return this;
    }

    public int getRetryTimeInterval() {
        return this.retryTimeInterval;
    }

    public Configuration setRetryTimeInterval(int retryTimeInterval) {
        this.retryTimeInterval = retryTimeInterval;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public Configuration setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public Configuration setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public Configuration setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        return this;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public Configuration setSslParameters(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Configuration setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public Configuration merge(SslConfiguration sslConfiguration) {
        if (sslConfiguration == null) {
            return this;
        }
        this.setSslParameters(sslConfiguration.getSslParameters());
        this.setSslSocketFactory(sslConfiguration.getSslSocketFactory());
        this.setHostnameVerifier(sslConfiguration.getHostnameVerifier());
        this.setSslContextFactory(sslConfiguration.getSslContextFactory());
        return this;
    }

    public static Configuration valueOf(RedisURI uri) {
        Configuration configuration = Configuration.defaultSetting();
        Map<String, String> parameters = uri.parameters;
        if (parameters.containsKey("connectionTimeout")) {
            configuration.setConnectionTimeout(Configuration.getInt(parameters.get("connectionTimeout"), 30000));
        }
        if (parameters.containsKey("readTimeout")) {
            configuration.setReadTimeout(Configuration.getInt(parameters.get("readTimeout"), 30000));
        }
        if (parameters.containsKey("receiveBufferSize")) {
            configuration.setReceiveBufferSize(Configuration.getInt(parameters.get("receiveBufferSize"), 0));
        }
        if (parameters.containsKey("sendBufferSize")) {
            configuration.setSendBufferSize(Configuration.getInt(parameters.get("sendBufferSize"), 0));
        }
        if (parameters.containsKey("retries")) {
            configuration.setRetries(Configuration.getInt(parameters.get("retries"), 5));
        }
        if (parameters.containsKey("retryTimeInterval")) {
            configuration.setRetryTimeInterval(Configuration.getInt(parameters.get("retryTimeInterval"), 1000));
        }
        if (parameters.containsKey("bufferSize")) {
            configuration.setBufferSize(Configuration.getInt(parameters.get("bufferSize"), 8192));
        }
        if (parameters.containsKey("authUser")) {
            configuration.setAuthPassword(parameters.get("authUser"));
        }
        if (parameters.containsKey("authPassword")) {
            configuration.setAuthPassword(parameters.get("authPassword"));
        }
        if (parameters.containsKey("discardRdbEvent")) {
            configuration.setDiscardRdbEvent(Configuration.getBool(parameters.get("discardRdbEvent"), false));
        }
        if (parameters.containsKey("asyncCachedBytes")) {
            configuration.setAsyncCachedBytes(Configuration.getInt(parameters.get("asyncCachedBytes"), 524288));
        }
        if (parameters.containsKey("rateLimit")) {
            configuration.setRateLimit(Configuration.getInt(parameters.get("rateLimit"), 0));
        }
        if (parameters.containsKey("verbose")) {
            configuration.setVerbose(Configuration.getBool(parameters.get("verbose"), false));
        }
        if (parameters.containsKey("heartbeatPeriod")) {
            configuration.setHeartbeatPeriod(Configuration.getInt(parameters.get("heartbeatPeriod"), 1000));
        }
        if (parameters.containsKey("useDefaultExceptionListener")) {
            configuration.setUseDefaultExceptionListener(Configuration.getBool(parameters.get("useDefaultExceptionListener"), false));
        }
        if (parameters.containsKey("ssl")) {
            configuration.setSsl(Configuration.getBool(parameters.get("ssl"), false));
        }
        if (parameters.containsKey("replId")) {
            configuration.setReplId(parameters.get("replId"));
        }
        if (parameters.containsKey("replStreamDB")) {
            configuration.setReplStreamDB(Configuration.getInt(parameters.get("replStreamDB"), -1));
        }
        if (parameters.containsKey("replOffset")) {
            configuration.setReplOffset(Configuration.getLong(parameters.get("replOffset"), -1L));
        }
        if (uri.isSsl()) {
            configuration.setSsl(true);
        }
        if (uri.getUser() != null) {
            configuration.setAuthUser(uri.getUser());
        }
        if (uri.getPassword() != null) {
            configuration.setAuthPassword(uri.getPassword());
        }
        return configuration;
    }

    private static boolean getBool(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        if (value.equals("true") || value.equals("yes")) {
            return true;
        }
        return defaultValue;
    }

    private static int getInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static long getLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String toString() {
        return "Configuration{connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", receiveBufferSize=" + this.receiveBufferSize + ", sendBufferSize=" + this.sendBufferSize + ", retries=" + this.retries + ", retryTimeInterval=" + this.retryTimeInterval + ", bufferSize=" + this.bufferSize + ", authUser='" + this.authUser + '\'' + ", authPassword='" + this.authPassword + '\'' + ", discardRdbEvent=" + this.discardRdbEvent + ", asyncCachedBytes=" + this.asyncCachedBytes + ", rateLimit=" + this.rateLimit + ", verbose=" + this.verbose + ", heartbeatPeriod=" + this.heartbeatPeriod + ", useDefaultExceptionListener=" + this.useDefaultExceptionListener + ", ssl=" + this.ssl + ", sslSocketFactory=" + this.sslSocketFactory + ", sslContextFactory=" + this.sslContextFactory + ", sslParameters=" + this.sslParameters + ", hostnameVerifier=" + this.hostnameVerifier + ", replId='" + this.replId + '\'' + ", replStreamDB=" + this.replStreamDB + ", replOffset=" + this.replOffset + '}';
    }
}

