/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.AbstractReplicator;
import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.DefaultExceptionListener;
import com.moilioncircle.redis.replicator.Status;
import com.moilioncircle.redis.replicator.io.PeekableInputStream;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.io.XPipedInputStream;
import com.moilioncircle.redis.replicator.io.XPipedOutputStream;
import com.moilioncircle.redis.replicator.rdb.RdbParser;
import com.moilioncircle.redis.replicator.rdb.ScanRdbGenerator;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisScanReplicator
extends AbstractReplicator
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(RedisScanReplicator.class);
    protected final int port;
    protected final String host;
    protected volatile Throwable exception;
    protected XPipedOutputStream outputStream;
    protected final ThreadFactory threadFactory = Executors.defaultThreadFactory();

    public RedisScanReplicator(String host, int port, Configuration configuration) {
        Objects.requireNonNull(host);
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("illegal argument port: " + port);
        }
        Objects.requireNonNull(configuration);
        this.host = host;
        this.port = port;
        this.configuration = configuration;
        if (configuration.isUseDefaultExceptionListener()) {
            this.addExceptionListener(new DefaultExceptionListener());
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        try {
            ScanRdbGenerator generator = new ScanRdbGenerator(this.host, this.port, this.configuration, this.outputStream);
            generator.generate();
        }
        catch (EOFException generator) {
        }
        catch (Throwable e) {
            this.exception = e;
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doOpen() throws IOException {
        this.outputStream = new XPipedOutputStream();
        PeekableInputStream in = new PeekableInputStream(new XPipedInputStream(this.outputStream, this.configuration.getAsyncCachedBytes()));
        this.inputStream = new RedisInputStream(in, this.configuration.getBufferSize());
        this.inputStream.setRawByteListeners(this.rawByteListeners);
        Thread worker = this.threadFactory.newThread(this);
        worker.start();
        try {
            if (in.peek() == 82) {
                new RdbParser(this.inputStream, this).parse();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.throwException(this.exception);
    }

    private void throwException(Throwable exception) throws IOException {
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof UncheckedIOException) {
                throw ((UncheckedIOException)exception).getCause();
            }
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.compareAndSet(Status.CONNECTED, Status.DISCONNECTING);
        try {
            if (this.inputStream != null) {
                this.inputStream.setRawByteListeners(null);
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.setStatus(Status.DISCONNECTED);
        }
    }
}

