/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.client;

import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.io.RedisOutputStream;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.ByteBuilder;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;

public class RESP2 {
    private final RedisInputStream in;
    private final RedisOutputStream out;

    RESP2(RedisInputStream in, RedisOutputStream out) {
        this.in = in;
        this.out = out;
    }

    void emit(byte[] ... command) throws IOException {
        this.out.write(42);
        this.out.write(String.valueOf(command.length).getBytes());
        this.out.writeCrLf();
        for (byte[] element : command) {
            this.out.write(36);
            this.out.write(String.valueOf(element.length).getBytes());
            this.out.writeCrLf();
            this.out.write(element);
            this.out.writeCrLf();
        }
        this.out.flush();
    }

    Node parse() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 36: {
                ByteBuilder builder = ByteBuilder.allocate(32);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) break;
                    builder.put((byte)c);
                }
                long len = Long.parseLong(builder.toString());
                if (len == -1L) {
                    return new Node(Type.NULL, null);
                }
                Node r = new Node(Type.STRING, this.in.readBytes(len));
                c = this.in.read();
                if (c != 13) {
                    throw new AssertionError((Object)("expect '\\r' but :" + (char)c));
                }
                c = this.in.read();
                if (c != 10) {
                    throw new AssertionError((Object)("expect '\\n' but :" + (char)c));
                }
                return r;
            }
            case 58: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) break;
                    builder.put((byte)c);
                }
                return new Node(Type.NUMBER, Long.parseLong(builder.toString()));
            }
            case 42: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) break;
                    builder.put((byte)c);
                }
                long len = Long.parseLong(builder.toString());
                if (len == -1L) {
                    return new Node(Type.NULL, null);
                }
                Node[] ary = new Node[(int)len];
                int i = 0;
                while ((long)i < len) {
                    Node obj;
                    ary[i] = obj = this.parse();
                    ++i;
                }
                return new Node(Type.ARRAY, ary);
            }
            case 43: {
                ByteBuilder builder = ByteBuilder.allocate(128);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) {
                        return new Node(Type.STRING, new ByteArray(builder.array()));
                    }
                    builder.put((byte)c);
                }
            }
            case 45: {
                ByteBuilder builder = ByteBuilder.allocate(32);
                while (true) {
                    if ((c = this.in.read()) != 13) {
                        builder.put((byte)c);
                        continue;
                    }
                    c = this.in.read();
                    if (c == 10) {
                        return new Node(Type.ERROR, new ByteArray(builder.array()));
                    }
                    builder.put((byte)c);
                }
            }
        }
        throw new AssertionError((Object)("expect [$,:,*,+,-] but: " + (char)c));
    }

    public static class Node {
        public final Type type;
        public final Object value;

        private Node(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Long getNumber() {
            return this.type == Type.NUMBER ? (Long)this.value : null;
        }

        public Node[] getArray() {
            return this.type == Type.ARRAY ? (Node[])this.value : null;
        }

        public ByteArray getBytes() {
            return this.type == Type.STRING ? (ByteArray)this.value : null;
        }

        public String getError() {
            return this.type == Type.ERROR ? Strings.toString(((ByteArray)this.value).first()) : null;
        }

        public String getString() {
            return this.type == Type.STRING ? Strings.toString(((ByteArray)this.value).first()) : null;
        }
    }

    public static enum Type {
        ARRAY,
        NUMBER,
        STRING,
        ERROR,
        NULL;

    }
}

