/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.client;

import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.client.RESP2;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.io.RedisOutputStream;
import com.moilioncircle.redis.replicator.net.RedisSocketFactory;
import com.moilioncircle.redis.replicator.util.Strings;
import com.moilioncircle.redis.replicator.util.Tuples;
import com.moilioncircle.redis.replicator.util.type.Tuple2;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESP2Client
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RESP2Client.class);
    private final RESP2 resp2;
    private final String host;
    private final int port;
    private final Socket socket;
    private final RedisInputStream is;
    private final RedisOutputStream os;
    private final Configuration configuration;

    /*
     * Enabled aggressive block sorting
     */
    public RESP2Client(String host, int port, Configuration configuration) throws IOException {
        block9: {
            block10: {
                this.host = host;
                this.port = port;
                this.configuration = configuration;
                RedisSocketFactory socketFactory = new RedisSocketFactory(configuration);
                this.socket = socketFactory.createSocket(host, port, configuration.getConnectionTimeout());
                this.os = new RedisOutputStream(this.socket.getOutputStream());
                this.is = new RedisInputStream(this.socket.getInputStream(), configuration.getBufferSize());
                this.resp2 = new RESP2(this.is, this.os);
                String user = configuration.getAuthUser();
                String pswd = configuration.getAuthPassword();
                if (pswd == null) break block10;
                RESP2.Node auth = null;
                auth = user != null ? this.newCommand().invoke("auth", user, pswd) : this.newCommand().invoke("auth", pswd);
                if (auth.type != RESP2.Type.ERROR) break block9;
                String reply = auth.getError();
                String mask = "#" + Strings.mask(pswd);
                if (reply.contains("no password") || reply.contains("without any password")) {
                    if (user == null) {
                        logger.warn("[AUTH {}] failed. {}", (Object)mask, (Object)reply);
                        break block9;
                    } else {
                        logger.warn("[AUTH {} {}] failed. {}", new Object[]{user, mask, reply});
                    }
                    break block9;
                } else {
                    if (user == null) {
                        throw new AssertionError((Object)("[AUTH " + mask + "] failed. " + reply));
                    }
                    throw new AssertionError((Object)("[AUTH " + user + " " + mask + "] failed. " + reply));
                }
            }
            RESP2.Node ping = this.newCommand().invoke("ping");
            if (ping.type == RESP2.Type.ERROR) {
                String reply = ping.getError();
                if (reply.contains("NOAUTH")) {
                    throw new AssertionError((Object)reply);
                }
                if (reply.contains("NOPERM")) {
                    throw new AssertionError((Object)reply);
                }
                if (reply.contains("operation not permitted")) {
                    throw new AssertionError((Object)"-NOAUTH Authentication required.");
                }
                throw new IOException(reply);
            }
        }
        logger.info("connected to redis-server[{}:{}]", (Object)host, (Object)port);
    }

    public Command newCommand() {
        return new Command(this.resp2);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.info("socket closed. redis-server[{}:{}]", (Object)this.host, (Object)this.port);
    }

    public static RESP2Client valueOf(RESP2Client prev, int db, IOException reason, int attempts) throws IOException {
        if (reason != null) {
            logger.error("[redis-replicator] socket error. redis-server[{}:{}]", new Object[]{prev.host, prev.port, reason});
        }
        prev.close();
        if (reason != null) {
            logger.info("reconnecting to redis-server[{}:{}]. retry times:{}", new Object[]{prev.host, prev.port, attempts});
        }
        RESP2Client next = new RESP2Client(prev.host, prev.port, prev.configuration);
        RESP2.Node select = next.newCommand().invoke("select", String.valueOf(db));
        if (select.type == RESP2.Type.ERROR) {
            throw new IOException(select.getError());
        }
        return next;
    }

    public static class Command {
        private RESP2 resp2;
        private Queue<Tuple2<NodeConsumer, byte[][]>> commands;

        private Command(RESP2 resp2) {
            this.resp2 = resp2;
            this.commands = new LinkedList<Tuple2<NodeConsumer, byte[][]>>();
        }

        public Queue<Tuple2<NodeConsumer, byte[][]>> getCommands() {
            return new LinkedList<Tuple2<NodeConsumer, byte[][]>>(this.commands);
        }

        public void get() throws IOException {
            while (!this.commands.isEmpty()) {
                NodeConsumer consumer = this.commands.peek().getV1();
                consumer.accept(this.resp2.parse());
                this.commands.poll();
            }
        }

        public RESP2.Node invoke(byte[] ... command) throws IOException {
            this.resp2.emit(command);
            return this.resp2.parse();
        }

        public RESP2.Node invoke(String ... command) throws IOException {
            return this.invoke((byte[][])Arrays.stream(command).map(e -> e.getBytes()).toArray(x$0 -> new byte[x$0][]));
        }

        public Command post(NodeConsumer handler, byte[] ... command) throws IOException {
            this.resp2.emit(command);
            this.commands.offer(Tuples.of(handler, command));
            return this;
        }

        public Command post(NodeConsumer handler, String ... command) throws IOException {
            return this.post(handler, (byte[][])Arrays.stream(command).map(e -> e.getBytes()).toArray(x$0 -> new byte[x$0][]));
        }
    }

    public static interface NodeConsumer {
        public void accept(RESP2.Node var1) throws IOException;
    }

    public static interface Function<T, R> {
        public R apply(T var1) throws IOException;
    }
}

