/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncInputStream
extends InputStream {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final int DEFAULT_CAPACITY = 0x200000;
    protected Closeable resource;
    protected volatile IOException exception;
    protected final ByteRingBuffer ringBuffer;
    protected final ReentrantLock lock = new ReentrantLock(false);
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Condition bufferNotFull = this.lock.newCondition();
    protected final Condition bufferNotEmpty = this.lock.newCondition();

    public AbstractAsyncInputStream(Closeable resource) {
        this(resource, 0x200000);
    }

    public AbstractAsyncInputStream(Closeable resource, int size) {
        this.resource = resource;
        this.ringBuffer = new ByteRingBuffer(size);
    }

    @Override
    public int available() throws IOException {
        return this.ringBuffer.size();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            this.resource.close();
        }
        finally {
            this.lock.lock();
            try {
                this.bufferNotFull.signalAll();
                this.bufferNotEmpty.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.lock.lock();
        try {
            while (this.ringBuffer.isEmpty()) {
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.closed.get()) {
                    throw new EOFException();
                }
                this.bufferNotEmpty.awaitUninterruptibly();
                if (!this.closed.get()) continue;
                throw new EOFException();
            }
            int r = this.ringBuffer.read();
            this.bufferNotFull.signal();
            int n = r;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            while (this.ringBuffer.isEmpty()) {
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.closed.get()) {
                    throw new EOFException();
                }
                this.bufferNotEmpty.awaitUninterruptibly();
                if (!this.closed.get()) continue;
                throw new EOFException();
            }
            int r = this.ringBuffer.read(b, off, len);
            this.bufferNotFull.signal();
            int n = r;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int b) throws IOException {
        this.lock.lock();
        try {
            while (this.ringBuffer.isFull()) {
                if (this.closed.get()) {
                    throw new EOFException();
                }
                this.bufferNotFull.awaitUninterruptibly();
                if (!this.closed.get()) continue;
                throw new EOFException();
            }
            int w = this.ringBuffer.write(b);
            this.bufferNotEmpty.signal();
            int n = w;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            while (this.ringBuffer.isFull()) {
                if (this.closed.get()) {
                    throw new EOFException();
                }
                this.bufferNotFull.awaitUninterruptibly();
                if (!this.closed.get()) continue;
                throw new EOFException();
            }
            int w = this.ringBuffer.write(b, off, len);
            this.bufferNotEmpty.signal();
            int n = w;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected final class ByteRingBuffer {
        private int size;
        private int head;
        private int tail;
        private final byte[] buffer;

        public ByteRingBuffer(int capacity) {
            this.buffer = new byte[capacity];
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean isFull() {
            return this.size == this.buffer.length;
        }

        public int read() {
            int r = this.buffer[this.tail] & 0xFF;
            this.tail = (this.tail + 1) % this.buffer.length;
            --this.size;
            return r;
        }

        public int read(byte[] b, int off, int len) {
            int r = Math.min(this.size, len);
            if (this.head > this.tail) {
                System.arraycopy(this.buffer, this.tail, b, off, r);
            } else {
                int r1 = Math.min(this.buffer.length - this.tail, r);
                System.arraycopy(this.buffer, this.tail, b, off, r1);
                if (r1 < r) {
                    System.arraycopy(this.buffer, 0, b, off + r1, r - r1);
                }
            }
            this.tail = (this.tail + r) % this.buffer.length;
            this.size -= r;
            return r;
        }

        public int write(int b) {
            this.buffer[this.head] = (byte)b;
            this.head = (this.head + 1) % this.buffer.length;
            ++this.size;
            return 1;
        }

        public int write(byte[] b, int off, int len) {
            int w = Math.min(this.buffer.length - this.size, len);
            if (this.head < this.tail) {
                System.arraycopy(b, off, this.buffer, this.head, w);
            } else {
                int w1 = Math.min(this.buffer.length - this.head, w);
                System.arraycopy(b, off, this.buffer, this.head, w1);
                if (w1 < w) {
                    System.arraycopy(b, off + w1, this.buffer, 0, w - w1);
                }
            }
            this.head = (this.head + w) % this.buffer.length;
            this.size += w;
            return w;
        }
    }
}

