/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.io;

import com.moilioncircle.redis.replicator.io.AbstractAsyncInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class AsyncBufferedInputStream
extends AbstractAsyncInputStream
implements Runnable {
    protected final Thread worker;
    protected final ThreadFactory threadFactory;

    public AsyncBufferedInputStream(InputStream is) {
        this(is, 0x200000);
    }

    public AsyncBufferedInputStream(InputStream is, int size) {
        this(is, size, Executors.defaultThreadFactory());
    }

    public AsyncBufferedInputStream(InputStream is, int size, ThreadFactory tf) {
        super(is, size);
        this.threadFactory = tf;
        this.worker = this.threadFactory.newThread(this);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] buffer = new byte[524288];
            while (!this.closed.get()) {
                int r = ((InputStream)this.resource).read(buffer, 0, buffer.length);
                if (r < 0) {
                    throw new EOFException();
                }
                int offset = 0;
                while (r > 0) {
                    int w = this.write(buffer, offset, r);
                    r -= w;
                    offset += w;
                }
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
        catch (Exception e) {
            this.logger.error("failed to transfer data", (Throwable)e);
        }
        finally {
            if (!this.closed.get()) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    this.logger.error("failed to close is", (Throwable)e);
                }
            }
        }
    }
}

