/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.Lzf;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BaseRdbEncoder {
    public void rdbSaveTime(int time, OutputStream out) throws IOException {
        out.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(time).array());
    }

    public void rdbSaveMillisecondTime(long timestamp, OutputStream out) throws IOException {
        out.write(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(timestamp).array());
    }

    public int rdbSaveLen(long len, OutputStream out) throws IOException {
        byte[] ary = this.toUnsigned(len);
        BigInteger value = new BigInteger(1, ary);
        if (value.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) > 0) {
            out.write(129);
            out.write(ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).put(ary).array());
            return 9;
        }
        if (len < 64L) {
            out.write((byte)(len & 0xFFL | 0L));
            return 1;
        }
        if (len < 16384L) {
            out.write((byte)(len >> 8 & 0xFFL | 0x40L));
            out.write((byte)(len & 0xFFL));
            return 2;
        }
        if (len <= 0xFFFFFFFFL) {
            out.write(128);
            out.write(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt((int)len).array());
            return 5;
        }
        out.write(129);
        out.write(ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(len).array());
        return 9;
    }

    public byte[] rdbSaveLen(long len) throws IOException {
        byte[] ary = this.toUnsigned(len);
        BigInteger value = new BigInteger(1, ary);
        if (value.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) > 0) {
            return ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN).put((byte)-127).put(ary).array();
        }
        if (len < 64L) {
            return new byte[]{(byte)(len & 0xFFL | 0L)};
        }
        if (len < 16384L) {
            return new byte[]{(byte)(len >> 8 & 0xFFL | 0x40L), (byte)(len & 0xFFL)};
        }
        if (len <= 0xFFFFFFFFL) {
            return ByteBuffer.allocate(5).order(ByteOrder.BIG_ENDIAN).put((byte)-128).putInt((int)len).array();
        }
        return ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN).put((byte)-127).putLong(len).array();
    }

    public void rdbSaveDoubleValue(double value, OutputStream out) throws IOException {
        if (value == Double.NEGATIVE_INFINITY) {
            out.write(255);
        } else if (value == Double.POSITIVE_INFINITY) {
            out.write(254);
        } else if (Double.isNaN(value)) {
            out.write(253);
        } else {
            String str = null;
            str = value == (double)((long)value) ? Long.toString((long)value, 10) : String.format("%.17f", value);
            out.write(str.length());
            out.write(str.getBytes());
        }
    }

    public void rdbSaveBinaryFloatValue(float value, OutputStream out) throws IOException {
        out.write(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(Float.floatToIntBits(value)).array());
    }

    public void rdbSaveBinaryDoubleValue(double value, OutputStream out) throws IOException {
        out.write(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(Double.doubleToLongBits(value)).array());
    }

    public void rdbSaveEncodedStringObject(ByteArray bytes, OutputStream out) throws IOException {
        ByteArray compressed = new ByteArray(bytes.length() - 3L);
        long length = Lzf.encode(bytes, bytes.length(), compressed, 0L);
        if (length <= 0L) {
            this.rdbSavePlainStringObject(bytes, out);
        } else {
            int type = 195;
            out.write(type);
            this.rdbSaveLen(length, out);
            this.rdbSaveLen(bytes.length(), out);
            out.write(compressed.first(), 0, (int)length);
        }
    }

    public void rdbGenericSaveStringObject(ByteArray bytes, OutputStream out) throws IOException {
        if (bytes.length() > 20L) {
            this.rdbSaveEncodedStringObject(bytes, out);
        } else {
            this.rdbSavePlainStringObject(bytes, out);
        }
    }

    public void rdbSavePlainStringObject(ByteArray bytes, OutputStream out) throws IOException {
        this.rdbSaveLen(bytes.length(), out);
        out.write(bytes.first());
    }

    private byte[] toUnsigned(long value) {
        byte[] ary = new byte[8];
        for (int i = 0; i < 8; ++i) {
            ary[7 - i] = (byte)(value >>> (i << 3) & 0xFFL);
        }
        return ary;
    }
}

