/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.RdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Function;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.Stream;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.ByteArrayList;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import com.moilioncircle.redis.replicator.util.ByteArraySet;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRdbValueVisitor
extends RdbValueVisitor {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultRdbValueVisitor.class);
    protected final Replicator replicator;

    public DefaultRdbValueVisitor(Replicator replicator) {
        this.replicator = replicator;
    }

    @Override
    public <T> T applyFunction(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        Function function = new Function();
        function.setName(parser.rdbLoadPlainStringObject().first());
        function.setEngineName(parser.rdbLoadPlainStringObject().first());
        long hasDesc = parser.rdbLoadLen().len;
        if (hasDesc == 1L) {
            function.setDescription(parser.rdbLoadPlainStringObject().first());
        }
        function.setCode(parser.rdbLoadPlainStringObject().first());
        return (T)function;
    }

    @Override
    public <T> T applyFunction2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        Function function = new Function();
        function.setCode(parser.rdbLoadPlainStringObject().first());
        return (T)function;
    }

    @Override
    public <T> T applyString(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        byte[] val = parser.rdbLoadEncodedStringObject().first();
        return (T)val;
    }

    @Override
    public <T> T applyList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        ByteArrayList list = new ByteArrayList();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            list.add(element);
        }
        return (T)list;
    }

    @Override
    public <T> T applySet(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        ByteArraySet set = new ByteArraySet();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            set.add(element);
        }
        return (T)set;
    }

    @Override
    public <T> T applySetListPack(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ByteArraySet set = new ByteArraySet();
        listPack.skip(4L);
        for (int len = listPack.readInt(2); len > 0; --len) {
            byte[] element = BaseRdbParser.StringHelper.listPackEntry(listPack);
            set.add(element);
        }
        int lpend = listPack.read();
        if (lpend != 255) {
            throw new AssertionError((Object)("listpack expect 255 but " + lpend));
        }
        return (T)set;
    }

    @Override
    public <T> T applyZSet(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            double score = parser.rdbLoadDoubleValue();
            zset.add(new ZSetEntry(element, score));
        }
        return (T)zset;
    }

    @Override
    public <T> T applyZSet2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] element = parser.rdbLoadEncodedStringObject().first();
            double score = parser.rdbLoadBinaryDoubleValue();
            zset.add(new ZSetEntry(element, score));
        }
        return (T)zset;
    }

    @Override
    public <T> T applyHash(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        ByteArrayMap map = new ByteArrayMap();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            byte[] field = parser.rdbLoadEncodedStringObject().first();
            byte[] value = parser.rdbLoadEncodedStringObject().first();
            map.put(field, value);
        }
        return (T)map;
    }

    @Override
    public <T> T applyHashZipMap(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ByteArrayMap map = new ByteArrayMap();
        BaseRdbParser.LenHelper.zmlen(stream);
        int zmEleLen;
        while ((zmEleLen = BaseRdbParser.LenHelper.zmElementLen(stream)) != 255) {
            byte[] field = BaseRdbParser.StringHelper.bytes(stream, zmEleLen);
            zmEleLen = BaseRdbParser.LenHelper.zmElementLen(stream);
            if (zmEleLen == 255) {
                map.put(field, null);
                return (T)map;
            }
            int free = BaseRdbParser.LenHelper.free(stream);
            byte[] value = BaseRdbParser.StringHelper.bytes(stream, zmEleLen);
            BaseRdbParser.StringHelper.skip(stream, free);
            map.put(field, value);
        }
        return (T)map;
    }

    @Override
    public <T> T applyListZipList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ByteArrayList list = new ByteArrayList();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        for (int i = 0; i < zllen; ++i) {
            byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
            list.add(e);
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        return (T)list;
    }

    @Override
    public <T> T applySetIntSet(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ByteArraySet set = new ByteArraySet();
        int encoding = BaseRdbParser.LenHelper.encoding(stream);
        long lenOfContent = BaseRdbParser.LenHelper.lenOfContent(stream);
        block5: for (long i = 0L; i < lenOfContent; ++i) {
            switch (encoding) {
                case 2: {
                    String element = String.valueOf(stream.readInt(2));
                    set.add(element.getBytes());
                    continue block5;
                }
                case 4: {
                    String element = String.valueOf(stream.readInt(4));
                    set.add(element.getBytes());
                    continue block5;
                }
                case 8: {
                    String element = String.valueOf(stream.readLong(8));
                    set.add(element.getBytes());
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("expect encoding [2,4,8] but:" + encoding));
                }
            }
        }
        return (T)set;
    }

    @Override
    public <T> T applyZSetZipList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        for (int zllen = BaseRdbParser.LenHelper.zllen(stream); zllen > 0; --zllen) {
            byte[] element = BaseRdbParser.StringHelper.zipListEntry(stream);
            --zllen;
            double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.zipListEntry(stream)));
            zset.add(new ZSetEntry(element, score));
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        return (T)zset;
    }

    @Override
    public <T> T applyZSetListPack(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
        LinkedHashSet<ZSetEntry> zset = new LinkedHashSet<ZSetEntry>();
        listPack.skip(4L);
        for (int len = listPack.readInt(2); len > 0; --len) {
            byte[] element = BaseRdbParser.StringHelper.listPackEntry(listPack);
            --len;
            double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            zset.add(new ZSetEntry(element, score));
        }
        int lpend = listPack.read();
        if (lpend != 255) {
            throw new AssertionError((Object)("listpack expect 255 but " + lpend));
        }
        return (T)zset;
    }

    @Override
    public <T> T applyHashZipList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ByteArrayMap map = new ByteArrayMap();
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        for (int zllen = BaseRdbParser.LenHelper.zllen(stream); zllen > 0; --zllen) {
            byte[] field = BaseRdbParser.StringHelper.zipListEntry(stream);
            --zllen;
            byte[] value = BaseRdbParser.StringHelper.zipListEntry(stream);
            map.put(field, value);
        }
        int zlend = BaseRdbParser.LenHelper.zlend(stream);
        if (zlend != 255) {
            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
        }
        return (T)map;
    }

    @Override
    public <T> T applyHashListPack(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
        ByteArrayMap map = new ByteArrayMap();
        listPack.skip(4L);
        for (int len = listPack.readInt(2); len > 0; --len) {
            byte[] field = BaseRdbParser.StringHelper.listPackEntry(listPack);
            --len;
            byte[] value = BaseRdbParser.StringHelper.listPackEntry(listPack);
            map.put(field, value);
        }
        int lpend = listPack.read();
        if (lpend != 255) {
            throw new AssertionError((Object)("listpack expect 255 but " + lpend));
        }
        return (T)map;
    }

    @Override
    public <T> T applyListQuickList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        ByteArrayList list = new ByteArrayList();
        for (long i = 0L; i < len; ++i) {
            RedisInputStream stream = new RedisInputStream(parser.rdbGenericLoadStringObject(0));
            BaseRdbParser.LenHelper.zlbytes(stream);
            BaseRdbParser.LenHelper.zltail(stream);
            int zllen = BaseRdbParser.LenHelper.zllen(stream);
            for (int j = 0; j < zllen; ++j) {
                byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
                list.add(e);
            }
            int zlend = BaseRdbParser.LenHelper.zlend(stream);
            if (zlend != 255) {
                throw new AssertionError((Object)("zlend expect 255 but " + zlend));
            }
        }
        return (T)list;
    }

    @Override
    public <T> T applyListQuickList2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        ByteArrayList list = new ByteArrayList();
        for (long i = 0L; i < len; ++i) {
            long container = parser.rdbLoadLen().len;
            ByteArray bytes = parser.rdbLoadPlainStringObject();
            if (container == 1L) {
                list.add(bytes.first());
                continue;
            }
            if (container == 2L) {
                RedisInputStream listPack = new RedisInputStream(bytes);
                listPack.skip(4L);
                int innerLen = listPack.readInt(2);
                for (int j = 0; j < innerLen; ++j) {
                    byte[] e = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    list.add(e);
                }
                int lpend = listPack.read();
                if (lpend != 255) {
                    throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                }
                continue;
            }
            throw new UnsupportedOperationException(String.valueOf(container));
        }
        return (T)list;
    }

    @Override
    public <T> T applyModule(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
        }
        Module module = moduleParser.parse(in, 1);
        return (T)module;
    }

    @Override
    public <T> T applyModule2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        Module module = null;
        if (moduleParser == null) {
            logger.warn("module parser[{}, {}] not register. rdb type: [RDB_TYPE_MODULE_2]. module parse skipped.", (Object)moduleName, (Object)moduleVersion);
            SkipRdbParser skipRdbParser = new SkipRdbParser(in);
            skipRdbParser.rdbLoadCheckModuleValue();
        } else {
            module = moduleParser.parse(in, 2);
            long eof = parser.rdbLoadLen().len;
            if (eof != 0L) {
                throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
            }
        }
        return (T)module;
    }

    protected ModuleParser<? extends Module> lookupModuleParser(String moduleName, int moduleVersion) {
        return this.replicator.getModuleParser(moduleName, moduleVersion);
    }

    @Override
    public <T> T applyStreamListPacks(RedisInputStream in, int version) throws IOException {
        return this.applyStreamListPacks(in, version, 15);
    }

    @Override
    public <T> T applyStreamListPacks2(RedisInputStream in, int version) throws IOException {
        return this.applyStreamListPacks(in, version, 19);
    }

    @Override
    public <T> T applyStreamListPacks3(RedisInputStream in, int version) throws IOException {
        return this.applyStreamListPacks(in, version, 21);
    }

    protected <T> T applyStreamListPacks(RedisInputStream in, int version, int type) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        Stream stream = new Stream();
        TreeMap<Stream.ID, Stream.Entry> entries = new TreeMap<Stream.ID, Stream.Entry>(Stream.ID.COMPARATOR);
        long listPacks = parser.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            RedisInputStream rawId = new RedisInputStream(parser.rdbLoadPlainStringObject());
            Stream.ID baseId = new Stream.ID(rawId.readLong(8, false), rawId.readLong(8, false));
            RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
            listPack.skip(4L);
            listPack.skip(2L);
            long count = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            long deleted = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            int numFields = Integer.parseInt(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
            byte[][] tempFields = new byte[numFields][];
            for (int i = 0; i < numFields; ++i) {
                tempFields[i] = BaseRdbParser.StringHelper.listPackEntry(listPack);
            }
            BaseRdbParser.StringHelper.listPackEntry(listPack);
            long total = count + deleted;
            while (total-- > 0L) {
                int i;
                boolean delete;
                ByteArrayMap fields = new ByteArrayMap();
                int flag = Integer.parseInt(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                long ms = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                long seq = Long.parseLong(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                Stream.ID id = baseId.delta(ms, seq);
                boolean bl = delete = (flag & 1) != 0;
                if ((flag & 2) != 0) {
                    for (i = 0; i < numFields; ++i) {
                        byte[] value = BaseRdbParser.StringHelper.listPackEntry(listPack);
                        byte[] field = tempFields[i];
                        fields.put(field, value);
                    }
                    entries.put(id, new Stream.Entry(id, delete, fields));
                } else {
                    numFields = Integer.parseInt(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                    for (i = 0; i < numFields; ++i) {
                        byte[] field = BaseRdbParser.StringHelper.listPackEntry(listPack);
                        byte[] value = BaseRdbParser.StringHelper.listPackEntry(listPack);
                        fields.put(field, value);
                    }
                    entries.put(id, new Stream.Entry(id, delete, fields));
                }
                BaseRdbParser.StringHelper.listPackEntry(listPack);
            }
            int lpend = listPack.read();
            if (lpend != 255) {
                throw new AssertionError((Object)("listpack expect 255 but " + lpend));
            }
        }
        long length = parser.rdbLoadLen().len;
        Stream.ID lastId = new Stream.ID(parser.rdbLoadLen().len, parser.rdbLoadLen().len);
        Stream.ID firstId = null;
        Stream.ID maxDeletedEntryId = null;
        Long entriesAdded = null;
        if (type >= 19) {
            firstId = new Stream.ID(parser.rdbLoadLen().len, parser.rdbLoadLen().len);
            maxDeletedEntryId = new Stream.ID(parser.rdbLoadLen().len, parser.rdbLoadLen().len);
            entriesAdded = parser.rdbLoadLen().len;
        }
        ArrayList<Stream.Group> groups = new ArrayList<Stream.Group>();
        long groupCount = parser.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            Stream.Group group = new Stream.Group();
            byte[] groupName = parser.rdbLoadPlainStringObject().first();
            Stream.ID groupLastId = new Stream.ID(parser.rdbLoadLen().len, parser.rdbLoadLen().len);
            Long entriesRead = null;
            if (type >= 19) {
                entriesRead = parser.rdbLoadLen().len;
            }
            TreeMap<Stream.ID, Stream.Nack> groupPendingEntries = new TreeMap<Stream.ID, Stream.Nack>(Stream.ID.COMPARATOR);
            long globalPel = parser.rdbLoadLen().len;
            while (globalPel-- > 0L) {
                Stream.ID rawId = new Stream.ID(in.readLong(8, false), in.readLong(8, false));
                long deliveryTime = parser.rdbLoadMillisecondTime();
                long deliveryCount = parser.rdbLoadLen().len;
                groupPendingEntries.put(rawId, new Stream.Nack(rawId, null, deliveryTime, deliveryCount));
            }
            ArrayList<Stream.Consumer> consumers = new ArrayList<Stream.Consumer>();
            long consumerCount = parser.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                Stream.Consumer consumer = new Stream.Consumer();
                byte[] consumerName = parser.rdbLoadPlainStringObject().first();
                long seenTime = parser.rdbLoadMillisecondTime();
                long activeTime = -1L;
                if (type >= 21) {
                    activeTime = parser.rdbLoadMillisecondTime();
                }
                TreeMap<Stream.ID, Stream.Nack> consumerPendingEntries = new TreeMap<Stream.ID, Stream.Nack>(Stream.ID.COMPARATOR);
                long pel = parser.rdbLoadLen().len;
                while (pel-- > 0L) {
                    Stream.ID rawId = new Stream.ID(in.readLong(8, false), in.readLong(8, false));
                    Stream.Nack nack = (Stream.Nack)groupPendingEntries.get(rawId);
                    nack.setConsumer(consumer);
                    consumerPendingEntries.put(rawId, nack);
                }
                consumer.setName(consumerName);
                consumer.setSeenTime(seenTime);
                if (type >= 21) {
                    consumer.setActiveTime(activeTime);
                }
                consumer.setPendingEntries(consumerPendingEntries);
                consumers.add(consumer);
            }
            group.setName(groupName);
            group.setLastId(groupLastId);
            if (type >= 19) {
                group.setEntriesRead(entriesRead);
            }
            group.setPendingEntries(groupPendingEntries);
            group.setConsumers(consumers);
            groups.add(group);
        }
        stream.setLastId(lastId);
        if (type >= 19) {
            stream.setFirstId(firstId);
            stream.setMaxDeletedEntryId(maxDeletedEntryId);
            stream.setEntriesAdded(entriesAdded);
        }
        stream.setEntries(entries);
        stream.setLength(length);
        stream.setGroups(groups);
        return (T)stream;
    }
}

