/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb;

import com.moilioncircle.redis.replicator.Configuration;
import com.moilioncircle.redis.replicator.client.RESP2;
import com.moilioncircle.redis.replicator.client.RESP2Client;
import com.moilioncircle.redis.replicator.io.CRCOutputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbEncoder;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.Strings;
import com.moilioncircle.redis.replicator.util.type.Tuple2;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class ScanRdbGenerator {
    private int db = 0;
    private RESP2Client client;
    protected final int port;
    protected final String host;
    private final CRCOutputStream out;
    private final Configuration configuration;
    private static Map<String, Integer> VERSIONS = new HashMap<String, Integer>();

    public ScanRdbGenerator(String host, int port, Configuration configuration, OutputStream out) {
        this.host = host;
        this.port = port;
        this.configuration = configuration;
        this.out = new CRCOutputStream(new BufferedOutputStream(out, this.configuration.getBufferSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        try {
            int i;
            this.client = new RESP2Client(this.host, this.port, this.configuration);
            int version = 0;
            String ver = null;
            String bits = null;
            RESP2.Node server = this.retry((RESP2Client client) -> {
                RESP2Client.Command r = client.newCommand();
                return r.invoke("info", "server");
            });
            if (server.type == RESP2.Type.ERROR) {
                throw new IOException(server.getError());
            }
            String value = server.getString();
            String[] lines = value.split("\r\n");
            for (i = 1; i < lines.length; ++i) {
                String val;
                String[] kv = lines[i].split(":");
                String key = kv[0];
                if (key.equals("redis_version")) {
                    ver = val = kv[1];
                    if (!VERSIONS.containsKey(val = val.substring(0, val.lastIndexOf(46)))) {
                        throw new AssertionError((Object)("unsupported redis version :" + val));
                    }
                    version = VERSIONS.get(val);
                    continue;
                }
                if (!key.equals("arch_bits")) continue;
                bits = val = kv[1];
            }
            this.out.write("REDIS".getBytes());
            this.out.write(Strings.lappend(version, 4, '0').getBytes());
            if (version >= 7) {
                this.generateAux("redis-ver", ver);
                this.generateAux("redis-bits", bits);
                this.generateAux("ctime", String.valueOf(System.currentTimeMillis() / 1000L));
                RESP2.Node memory = this.retry((RESP2Client client) -> {
                    RESP2Client.Command r = client.newCommand();
                    return r.invoke("info", "memory");
                });
                if (memory.type == RESP2.Type.STRING) {
                    String value2 = memory.getString();
                    String[] lines2 = value2.split("\r\n");
                    for (int i2 = 1; i2 < lines2.length; ++i2) {
                        String[] kv = lines2[i2].split(":");
                        String key = kv[0];
                        if (!key.equals("used_memory")) continue;
                        String val = kv[1];
                        this.generateAux("used-mem", val);
                    }
                }
            }
            if (version >= 10) {
                RESP2.Node functions = this.retry((RESP2Client client) -> {
                    RESP2Client.Command r = client.newCommand();
                    return r.invoke("function", "dump");
                });
                if (functions.type == RESP2.Type.ERROR) {
                    throw new IOException(functions.getError());
                }
                ByteArray funcs = functions.getBytes();
                if (funcs != null) {
                    funcs.writeTo(this.out, 0L, funcs.length() - 10L);
                }
            }
            RESP2.Node keyspace = this.retry((RESP2Client client) -> {
                RESP2Client.Command r = client.newCommand();
                return r.invoke("info", "keyspace");
            });
            String[] line = keyspace.getString().split("\r\n");
            for (i = 1; i < line.length; ++i) {
                String[] ary = line[i].split(":");
                Integer dbnum = Integer.parseInt(ary[0].substring(2));
                ary = ary[1].split(",");
                long dbsize = Long.parseLong(ary[0].split("=")[1]);
                long expires = Long.parseLong(ary[1].split("=")[1]);
                DB db = new DB(dbnum.intValue(), dbsize, expires);
                this.generateDB(db, version);
            }
            this.out.write(255);
            this.out.write(this.out.getCRC64());
            this.out.flush();
        }
        finally {
            this.close();
        }
    }

    private void generateAux(String key, String val) throws IOException {
        if (val == null) {
            return;
        }
        BaseRdbEncoder encoder = new BaseRdbEncoder();
        this.out.write(250);
        encoder.rdbGenericSaveStringObject(new ByteArray(key.getBytes()), this.out);
        encoder.rdbGenericSaveStringObject(new ByteArray(val.getBytes()), this.out);
    }

    private void generateDB(DB db, int version) throws IOException {
        BaseRdbEncoder encoder = new BaseRdbEncoder();
        RESP2.Node select = this.retry((RESP2Client client) -> {
            RESP2Client.Command r = client.newCommand();
            return r.invoke("select", String.valueOf(db.getDbNumber()));
        });
        if (select.type == RESP2.Type.ERROR) {
            throw new IOException(select.getError());
        }
        this.db = (int)db.getDbNumber();
        this.out.write(254);
        encoder.rdbSaveLen(db.getDbNumber(), this.out);
        if (version >= 7) {
            this.out.write(251);
            encoder.rdbSaveLen(db.getDbsize(), this.out);
            encoder.rdbSaveLen(db.getExpires(), this.out);
        }
        String cursor = "0";
        String step = String.valueOf(this.configuration.getScanStep());
        do {
            String temp = cursor;
            RESP2.Node scan = this.retry((RESP2Client client) -> {
                RESP2Client.Command r = client.newCommand();
                return r.invoke("scan", temp, "count", step);
            });
            if (scan.type == RESP2.Type.ERROR) {
                throw new IOException(scan.getError());
            }
            RESP2.Node[] ary = scan.getArray();
            cursor = ary[0].getString();
            RESP2Client.Command command = this.retry((RESP2Client client) -> {
                RESP2Client.Command r = client.newCommand();
                RESP2.Node[] nodes = ary[1].getArray();
                for (int i = 0; i < nodes.length; ++i) {
                    TTLContext context;
                    byte[] key = nodes[i].getBytes().first();
                    if (version >= 10) {
                        context = new PExpireTimeNodeConsumer();
                        r.post((RESP2Client.NodeConsumer)((Object)context), "pexpiretime".getBytes(), key);
                        r.post((RESP2Client.NodeConsumer)new DumpNodeConsumer(key, this.out, context), "dump".getBytes(), key);
                        continue;
                    }
                    context = new PTTLNodeConsumer();
                    r.post((RESP2Client.NodeConsumer)((Object)context), "pttl".getBytes(), key);
                    r.post((RESP2Client.NodeConsumer)new DumpNodeConsumer(key, this.out, context), "dump".getBytes(), key);
                }
                return r;
            });
            this.retry(command);
        } while (!cursor.equals("0"));
    }

    private RESP2Client recreate(RESP2Client prev, int db, IOException reason) throws IOException {
        IOException exception = reason;
        for (int i = 0; i < this.configuration.getRetries() || this.configuration.getRetries() <= 0; ++i) {
            try {
                return RESP2Client.valueOf(prev, db, exception, i + 1);
            }
            catch (IOException e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    private <T> T retry(RESP2Client.Function<RESP2Client, T> function) throws IOException {
        IOException exception = null;
        for (int i = 0; i < this.configuration.getRetries() || this.configuration.getRetries() <= 0; ++i) {
            try {
                return function.apply(this.client);
            }
            catch (EOFException e) {
                throw e;
            }
            catch (IOException e) {
                exception = e;
                this.client = this.recreate(this.client, this.db, e);
                continue;
            }
        }
        throw exception;
    }

    private void retry(RESP2Client.Command prev) throws IOException {
        IOException exception = null;
        for (int i = 0; i < this.configuration.getRetries() || this.configuration.getRetries() <= 0; ++i) {
            try {
                prev.get();
                return;
            }
            catch (EOFException e) {
                throw e;
            }
            catch (IOException e) {
                RESP2Client.Command next;
                exception = e;
                this.client = this.recreate(this.client, this.db, e);
                Queue<Tuple2<RESP2Client.NodeConsumer, byte[][]>> commands = prev.getCommands();
                prev = next = this.retry((RESP2Client client) -> {
                    RESP2Client.Command r = client.newCommand();
                    while (!commands.isEmpty()) {
                        Tuple2 tuple = (Tuple2)commands.poll();
                        r.post((RESP2Client.NodeConsumer)tuple.getV1(), (byte[][])tuple.getV2());
                    }
                    return r;
                });
                continue;
            }
        }
        throw exception;
    }

    private void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        VERSIONS.put("2.6", 6);
        VERSIONS.put("2.8", 6);
        VERSIONS.put("3.0", 6);
        VERSIONS.put("3.2", 7);
        VERSIONS.put("4.0", 8);
        VERSIONS.put("5.0", 9);
        VERSIONS.put("6.0", 9);
        VERSIONS.put("6.2", 9);
        VERSIONS.put("7.0", 10);
        VERSIONS.put("7.2", 11);
    }

    private static class DumpNodeConsumer
    implements RESP2Client.NodeConsumer {
        private byte[] key;
        private OutputStream out;
        private TTLContext context;
        private BaseRdbEncoder encoder = new BaseRdbEncoder();

        public DumpNodeConsumer(byte[] key, OutputStream out, TTLContext context) {
            this.key = key;
            this.out = out;
            this.context = context;
        }

        @Override
        public void accept(RESP2.Node node) throws IOException {
            if (node.type == RESP2.Type.ERROR) {
                throw new IOException(node.getError());
            }
            if (node.value != null) {
                Long ttl = this.context.getTTL();
                if (ttl != null) {
                    this.out.write(252);
                    this.encoder.rdbSaveMillisecondTime(ttl, this.out);
                }
                ByteArray value = node.getBytes();
                byte type = value.get(0L);
                this.out.write(type);
                this.encoder.rdbGenericSaveStringObject(new ByteArray(this.key), this.out);
                value.writeTo(this.out, 1L, value.length() - 11L);
            }
        }
    }

    private static class PExpireTimeNodeConsumer
    implements RESP2Client.NodeConsumer,
    TTLContext {
        private Long ttl;

        private PExpireTimeNodeConsumer() {
        }

        @Override
        public Long getTTL() {
            return this.ttl;
        }

        @Override
        public void accept(RESP2.Node node) throws IOException {
            if (node.type == RESP2.Type.ERROR) {
                throw new IOException(node.getError());
            }
            Long ttl = node.getNumber();
            if (ttl >= 0L) {
                this.ttl = ttl;
            }
        }
    }

    private static class PTTLNodeConsumer
    implements RESP2Client.NodeConsumer,
    TTLContext {
        private Long ttl;

        private PTTLNodeConsumer() {
        }

        @Override
        public Long getTTL() {
            return this.ttl;
        }

        @Override
        public void accept(RESP2.Node node) throws IOException {
            if (node.type == RESP2.Type.ERROR) {
                throw new IOException(node.getError());
            }
            Long ttl = node.getNumber();
            if (ttl >= 0L) {
                this.ttl = System.currentTimeMillis() + ttl;
            }
        }
    }

    private static interface TTLContext {
        public Long getTTL();
    }
}

