/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.RdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.ContextKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.dump.DumpRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpKeyValuePair;
import java.io.IOException;

public class DumpRdbVisitor
extends DefaultRdbVisitor {
    protected int version = -1;

    public DumpRdbVisitor(Replicator replicator) {
        this(replicator, -1);
    }

    public DumpRdbVisitor(Replicator replicator, int version) {
        this(replicator, version, 8192);
    }

    public DumpRdbVisitor(Replicator replicator, int version, int size) {
        super(replicator, new DumpRdbValueVisitor(replicator, version, size));
        this.version = version;
    }

    public DumpRdbVisitor(Replicator replicator, RdbValueVisitor valueVisitor) {
        super(replicator, valueVisitor);
    }

    @Override
    public Event applyString(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o0 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o0.setValueRdbType(0);
        o0.setKey(key);
        o0.setValue((byte[])this.valueVisitor.applyString(in, version));
        return context.valueOf(o0);
    }

    @Override
    public Event applyList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o1 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o1.setValueRdbType(1);
        o1.setKey(key);
        o1.setValue((byte[])this.valueVisitor.applyList(in, version));
        return context.valueOf(o1);
    }

    @Override
    public Event applySet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o2 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o2.setValueRdbType(2);
        o2.setKey(key);
        o2.setValue((byte[])this.valueVisitor.applySet(in, version));
        return context.valueOf(o2);
    }

    @Override
    public Event applySetListPack(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o20 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 11) {
            o20.setValueRdbType(2);
        } else {
            o20.setValueRdbType(20);
        }
        o20.setKey(key);
        o20.setValue((byte[])this.valueVisitor.applySetListPack(in, version));
        return context.valueOf(o20);
    }

    @Override
    public Event applyZSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o3 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o3.setValueRdbType(3);
        o3.setKey(key);
        o3.setValue((byte[])this.valueVisitor.applyZSet(in, version));
        return context.valueOf(o3);
    }

    @Override
    public Event applyZSet2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o5 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 8) {
            o5.setValueRdbType(3);
        } else {
            o5.setValueRdbType(5);
        }
        o5.setKey(key);
        o5.setValue((byte[])this.valueVisitor.applyZSet2(in, version));
        return context.valueOf(o5);
    }

    @Override
    public Event applyHash(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o4 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o4.setValueRdbType(4);
        o4.setKey(key);
        o4.setValue((byte[])this.valueVisitor.applyHash(in, version));
        return context.valueOf(o4);
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o9 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o9.setValueRdbType(9);
        o9.setKey(key);
        o9.setValue((byte[])this.valueVisitor.applyHashZipMap(in, version));
        return context.valueOf(o9);
    }

    @Override
    public Event applyListZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o10 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o10.setValueRdbType(10);
        o10.setKey(key);
        o10.setValue((byte[])this.valueVisitor.applyListZipList(in, version));
        return context.valueOf(o10);
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o11 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o11.setValueRdbType(11);
        o11.setKey(key);
        o11.setValue((byte[])this.valueVisitor.applySetIntSet(in, version));
        return context.valueOf(o11);
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o12 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o12.setValueRdbType(12);
        o12.setKey(key);
        o12.setValue((byte[])this.valueVisitor.applyZSetZipList(in, version));
        return context.valueOf(o12);
    }

    @Override
    public Event applyZSetListPack(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o17 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 10) {
            o17.setValueRdbType(3);
        } else {
            o17.setValueRdbType(17);
        }
        o17.setKey(key);
        o17.setValue((byte[])this.valueVisitor.applyZSetListPack(in, version));
        return context.valueOf(o17);
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o13 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o13.setValueRdbType(13);
        o13.setKey(key);
        o13.setValue((byte[])this.valueVisitor.applyHashZipList(in, version));
        return context.valueOf(o13);
    }

    @Override
    public Event applyHashListPack(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o16 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 10) {
            o16.setValueRdbType(4);
        } else {
            o16.setValueRdbType(16);
        }
        o16.setKey(key);
        o16.setValue((byte[])this.valueVisitor.applyHashListPack(in, version));
        return context.valueOf(o16);
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o14 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 7) {
            o14.setValueRdbType(1);
        } else {
            o14.setValueRdbType(14);
        }
        o14.setKey(key);
        o14.setValue((byte[])this.valueVisitor.applyListQuickList(in, version));
        return context.valueOf(o14);
    }

    @Override
    public Event applyListQuickList2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o18 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 10) {
            o18.setValueRdbType(1);
        } else {
            o18.setValueRdbType(18);
        }
        o18.setKey(key);
        o18.setValue((byte[])this.valueVisitor.applyListQuickList2(in, version));
        return context.valueOf(o18);
    }

    @Override
    public Event applyModule(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o6 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o6.setValueRdbType(6);
        o6.setKey(key);
        o6.setValue((byte[])this.valueVisitor.applyModule(in, version));
        return context.valueOf(o6);
    }

    @Override
    public Event applyModule2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o7 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o7.setValueRdbType(7);
        o7.setKey(key);
        o7.setValue((byte[])this.valueVisitor.applyModule2(in, version));
        return context.valueOf(o7);
    }

    @Override
    public Event applyStreamListPacks(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o15 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o15.setValueRdbType(15);
        o15.setKey(key);
        o15.setValue((byte[])this.valueVisitor.applyStreamListPacks(in, version));
        return context.valueOf(o15);
    }

    @Override
    public Event applyStreamListPacks2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o19 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 10) {
            o19.setValueRdbType(15);
        } else {
            o19.setValueRdbType(19);
        }
        o19.setKey(key);
        o19.setValue((byte[])this.valueVisitor.applyStreamListPacks2(in, version));
        return context.valueOf(o19);
    }

    @Override
    public Event applyStreamListPacks3(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o21 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        if (this.version != -1 && this.version < 11) {
            o21.setValueRdbType(15);
        } else {
            o21.setValueRdbType(21);
        }
        o21.setKey(key);
        o21.setValue((byte[])this.valueVisitor.applyStreamListPacks3(in, version));
        return context.valueOf(o21);
    }
}

