/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump.parser;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.EventListener;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.RdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Function;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePairs;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.Stream;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpFunction;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.dump.parser.DumpValueParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultDumpValueParser
implements DumpValueParser {
    protected final Replicator replicator;
    protected final RdbValueVisitor valueVisitor;

    public DefaultDumpValueParser(Replicator replicator) {
        Objects.requireNonNull(replicator);
        this.replicator = replicator;
        this.valueVisitor = new DefaultRdbValueVisitor(replicator);
    }

    @Override
    public void parse(DumpKeyValuePair kv, EventListener listener) {
        Objects.requireNonNull(listener).onEvent(this.replicator, this.parse(kv));
    }

    @Override
    public void parse(DumpFunction function, EventListener listener) {
        Objects.requireNonNull(listener).onEvent(this.replicator, this.parse(function));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Function parse(DumpFunction function) {
        Objects.requireNonNull(function);
        try (RedisInputStream in = new RedisInputStream(new ByteArray(function.getSerialized()));){
            int valueType = in.read();
            if (valueType == 246) {
                Function function2 = (Function)this.valueVisitor.applyFunction(in, 0);
                return function2;
            }
            if (valueType != 245) throw new AssertionError((Object)("unexpected value type:" + valueType));
            Function function3 = (Function)this.valueVisitor.applyFunction2(in, 0);
            return function3;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyValuePair<?, ?> parse(DumpKeyValuePair kv) {
        Objects.requireNonNull(kv);
        try (RedisInputStream in = new RedisInputStream(new ByteArray((byte[])kv.getValue()));){
            int valueType = in.read();
            switch (valueType) {
                case 0: {
                    KeyValuePair<byte[], byte[]> keyValuePair = KeyValuePairs.string(kv, (byte[])this.valueVisitor.applyString(in, 0));
                    return keyValuePair;
                }
                case 1: {
                    KeyValuePair<byte[], List<byte[]>> keyValuePair = KeyValuePairs.list(kv, (List)this.valueVisitor.applyList(in, 0));
                    return keyValuePair;
                }
                case 2: {
                    KeyValuePair<byte[], Set<byte[]>> keyValuePair = KeyValuePairs.set(kv, (Set)this.valueVisitor.applySet(in, 0));
                    return keyValuePair;
                }
                case 20: {
                    KeyValuePair<byte[], Set<byte[]>> keyValuePair = KeyValuePairs.set(kv, (Set)this.valueVisitor.applySetListPack(in, 0));
                    return keyValuePair;
                }
                case 3: {
                    KeyValuePair<byte[], Set<ZSetEntry>> keyValuePair = KeyValuePairs.zset(kv, (Set)this.valueVisitor.applyZSet(in, 0));
                    return keyValuePair;
                }
                case 5: {
                    KeyValuePair<byte[], Set<ZSetEntry>> keyValuePair = KeyValuePairs.zset(kv, (Set)this.valueVisitor.applyZSet2(in, 0));
                    return keyValuePair;
                }
                case 4: {
                    KeyValuePair<byte[], Map<byte[], byte[]>> keyValuePair = KeyValuePairs.hash(kv, (Map)this.valueVisitor.applyHash(in, 0));
                    return keyValuePair;
                }
                case 9: {
                    KeyValuePair<byte[], Map<byte[], byte[]>> keyValuePair = KeyValuePairs.hash(kv, (Map)this.valueVisitor.applyHashZipMap(in, 0));
                    return keyValuePair;
                }
                case 10: {
                    KeyValuePair<byte[], List<byte[]>> keyValuePair = KeyValuePairs.list(kv, (List)this.valueVisitor.applyListZipList(in, 0));
                    return keyValuePair;
                }
                case 11: {
                    KeyValuePair<byte[], Set<byte[]>> keyValuePair = KeyValuePairs.set(kv, (Set)this.valueVisitor.applySetIntSet(in, 0));
                    return keyValuePair;
                }
                case 12: {
                    KeyValuePair<byte[], Set<ZSetEntry>> keyValuePair = KeyValuePairs.zset(kv, (Set)this.valueVisitor.applyZSetZipList(in, 0));
                    return keyValuePair;
                }
                case 17: {
                    KeyValuePair<byte[], Set<ZSetEntry>> keyValuePair = KeyValuePairs.zset(kv, (Set)this.valueVisitor.applyZSetListPack(in, 0));
                    return keyValuePair;
                }
                case 13: {
                    KeyValuePair<byte[], Map<byte[], byte[]>> keyValuePair = KeyValuePairs.hash(kv, (Map)this.valueVisitor.applyHashZipList(in, 0));
                    return keyValuePair;
                }
                case 16: {
                    KeyValuePair<byte[], Map<byte[], byte[]>> keyValuePair = KeyValuePairs.hash(kv, (Map)this.valueVisitor.applyHashListPack(in, 0));
                    return keyValuePair;
                }
                case 14: {
                    KeyValuePair<byte[], List<byte[]>> keyValuePair = KeyValuePairs.list(kv, (List)this.valueVisitor.applyListQuickList(in, 0));
                    return keyValuePair;
                }
                case 18: {
                    KeyValuePair<byte[], List<byte[]>> keyValuePair = KeyValuePairs.list(kv, (List)this.valueVisitor.applyListQuickList2(in, 0));
                    return keyValuePair;
                }
                case 6: {
                    KeyValuePair<byte[], Module> keyValuePair = KeyValuePairs.module(kv, (Module)this.valueVisitor.applyModule(in, 0));
                    return keyValuePair;
                }
                case 7: {
                    KeyValuePair<byte[], Module> keyValuePair = KeyValuePairs.module(kv, (Module)this.valueVisitor.applyModule2(in, 0));
                    return keyValuePair;
                }
                case 15: {
                    KeyValuePair<byte[], Stream> keyValuePair = KeyValuePairs.stream(kv, (Stream)this.valueVisitor.applyStreamListPacks(in, 0));
                    return keyValuePair;
                }
                case 19: {
                    KeyValuePair<byte[], Stream> keyValuePair = KeyValuePairs.stream(kv, (Stream)this.valueVisitor.applyStreamListPacks2(in, 0));
                    return keyValuePair;
                }
                case 21: {
                    KeyValuePair<byte[], Stream> keyValuePair = KeyValuePairs.stream(kv, (Stream)this.valueVisitor.applyStreamListPacks3(in, 0));
                    return keyValuePair;
                }
            }
            throw new AssertionError((Object)("unexpected value type:" + valueType));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

