/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.iterable;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.util.ByteArray;
import com.moilioncircle.redis.replicator.util.Strings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;

public class ValueIterableRdbValueVisitor
extends DefaultRdbValueVisitor {
    public ValueIterableRdbValueVisitor(Replicator replicator) {
        super(replicator);
    }

    @Override
    public <T> T applyList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        Iter<byte[]> val = new Iter<byte[]>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public byte[] next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    --this.condition;
                    return element;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applySet(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        Iter<byte[]> val = new Iter<byte[]>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public byte[] next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    --this.condition;
                    return element;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applySetListPack(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
        listPack.skip(4L);
        int len = listPack.readInt(2);
        Iter<byte[]> val = new Iter<byte[]>((long)len, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int lpend = listPack.read();
                    if (lpend != 255) {
                        throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public byte[] next() {
                try {
                    byte[] element = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    --this.condition;
                    return element;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyZSet(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        Iter<ZSetEntry> val = new Iter<ZSetEntry>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    double score = this.parser.rdbLoadDoubleValue();
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyZSet2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        Iter<ZSetEntry> val = new Iter<ZSetEntry>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = this.parser.rdbLoadEncodedStringObject().first();
                    double score = this.parser.rdbLoadBinaryDoubleValue();
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyHash(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        Iter<Map.Entry<byte[], byte[]>> val = new Iter<Map.Entry<byte[], byte[]>>(len, parser){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                try {
                    byte[] field = this.parser.rdbLoadEncodedStringObject().first();
                    byte[] value = this.parser.rdbLoadEncodedStringObject().first();
                    --this.condition;
                    return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyHashZipMap(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zmlen(stream);
        HashZipMapIter val = new HashZipMapIter(stream);
        return (T)val;
    }

    @Override
    public <T> T applyListZipList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        Iter<byte[]> val = new Iter<byte[]>((long)zllen, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public byte[] next() {
                try {
                    byte[] e = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    return e;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applySetIntSet(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        final int encoding = BaseRdbParser.LenHelper.encoding(stream);
        long lenOfContent = BaseRdbParser.LenHelper.lenOfContent(stream);
        Iter<byte[]> val = new Iter<byte[]>(lenOfContent, null){

            @Override
            public boolean hasNext() {
                return this.condition > 0L;
            }

            @Override
            public byte[] next() {
                try {
                    switch (encoding) {
                        case 2: {
                            String element = String.valueOf(stream.readInt(2));
                            --this.condition;
                            return element.getBytes();
                        }
                        case 4: {
                            String element = String.valueOf(stream.readInt(4));
                            --this.condition;
                            return element.getBytes();
                        }
                        case 8: {
                            String element = String.valueOf(stream.readLong(8));
                            --this.condition;
                            return element.getBytes();
                        }
                    }
                    throw new AssertionError((Object)("expect encoding [2,4,8] but:" + encoding));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyZSetZipList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        Iter<ZSetEntry> val = new Iter<ZSetEntry>((long)zllen, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.zipListEntry(stream)));
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyZSetListPack(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
        listPack.skip(4L);
        int len = listPack.readInt(2);
        Iter<ZSetEntry> val = new Iter<ZSetEntry>((long)len, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int lpend = listPack.read();
                    if (lpend != 255) {
                        throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public ZSetEntry next() {
                try {
                    byte[] element = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    --this.condition;
                    double score = Double.valueOf(Strings.toString(BaseRdbParser.StringHelper.listPackEntry(listPack)));
                    --this.condition;
                    return new ZSetEntry(element, score);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyHashZipList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream stream = new RedisInputStream(parser.rdbLoadPlainStringObject());
        BaseRdbParser.LenHelper.zlbytes(stream);
        BaseRdbParser.LenHelper.zltail(stream);
        int zllen = BaseRdbParser.LenHelper.zllen(stream);
        Iter<Map.Entry<byte[], byte[]>> val = new Iter<Map.Entry<byte[], byte[]>>((long)zllen, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int zlend = BaseRdbParser.LenHelper.zlend(stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                try {
                    byte[] field = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    byte[] value = BaseRdbParser.StringHelper.zipListEntry(stream);
                    --this.condition;
                    return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyHashListPack(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        final RedisInputStream listPack = new RedisInputStream(parser.rdbLoadPlainStringObject());
        listPack.skip(4L);
        int len = listPack.readInt(2);
        Iter<Map.Entry<byte[], byte[]>> val = new Iter<Map.Entry<byte[], byte[]>>((long)len, null){

            @Override
            public boolean hasNext() {
                if (this.condition > 0L) {
                    return true;
                }
                try {
                    int lpend = listPack.read();
                    if (lpend != 255) {
                        throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                try {
                    byte[] field = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    --this.condition;
                    byte[] value = BaseRdbParser.StringHelper.listPackEntry(listPack);
                    --this.condition;
                    return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return (T)val;
    }

    @Override
    public <T> T applyListQuickList(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        QuickListIter val = new QuickListIter(len, parser);
        return (T)val;
    }

    @Override
    public <T> T applyListQuickList2(RedisInputStream in, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        long len = parser.rdbLoadLen().len;
        QuickList2Iter val = new QuickList2Iter(len, parser);
        return (T)val;
    }

    private static class QuickList2Iter
    extends Iter<byte[]> {
        protected int innerLen = -1;
        protected RedisInputStream listPack;

        private QuickList2Iter(long condition, BaseRdbParser parser) {
            super(condition, parser);
        }

        @Override
        public boolean hasNext() {
            return this.innerLen > 0 || this.condition > 0L;
        }

        @Override
        public byte[] next() {
            try {
                if (this.innerLen == -1 && this.condition > 0L) {
                    long container = this.parser.rdbLoadLen().len;
                    ByteArray bytes = this.parser.rdbLoadPlainStringObject();
                    if (container == 1L) {
                        this.innerLen = -1;
                        --this.condition;
                        return bytes.first();
                    }
                    if (container == 2L) {
                        this.listPack = new RedisInputStream(bytes);
                        this.listPack.skip(4L);
                        this.innerLen = this.listPack.readInt(2);
                        if (this.innerLen == 0) {
                            int lpend = this.listPack.read();
                            if (lpend != 255) {
                                throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                            }
                            this.innerLen = -1;
                            --this.condition;
                        }
                        if (this.hasNext()) {
                            return this.next();
                        }
                        throw new IllegalStateException("end of iterator");
                    }
                    throw new UnsupportedOperationException(String.valueOf(container));
                }
                byte[] e = BaseRdbParser.StringHelper.listPackEntry(this.listPack);
                --this.innerLen;
                if (this.innerLen == 0) {
                    int lpend = this.listPack.read();
                    if (lpend != 255) {
                        throw new AssertionError((Object)("listpack expect 255 but " + lpend));
                    }
                    this.innerLen = -1;
                    --this.condition;
                }
                return e;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class QuickListIter
    extends Iter<byte[]> {
        protected int zllen = -1;
        protected RedisInputStream stream;

        private QuickListIter(long condition, BaseRdbParser parser) {
            super(condition, parser);
        }

        @Override
        public boolean hasNext() {
            return this.zllen > 0 || this.condition > 0L;
        }

        @Override
        public byte[] next() {
            try {
                if (this.zllen == -1 && this.condition > 0L) {
                    this.stream = new RedisInputStream(this.parser.rdbGenericLoadStringObject(0));
                    BaseRdbParser.LenHelper.zlbytes(this.stream);
                    BaseRdbParser.LenHelper.zltail(this.stream);
                    this.zllen = BaseRdbParser.LenHelper.zllen(this.stream);
                    if (this.zllen == 0) {
                        int zlend = BaseRdbParser.LenHelper.zlend(this.stream);
                        if (zlend != 255) {
                            throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                        }
                        this.zllen = -1;
                        --this.condition;
                    }
                    if (this.hasNext()) {
                        return this.next();
                    }
                    throw new IllegalStateException("end of iterator");
                }
                byte[] e = BaseRdbParser.StringHelper.zipListEntry(this.stream);
                --this.zllen;
                if (this.zllen == 0) {
                    int zlend = BaseRdbParser.LenHelper.zlend(this.stream);
                    if (zlend != 255) {
                        throw new AssertionError((Object)("zlend expect 255 but " + zlend));
                    }
                    this.zllen = -1;
                    --this.condition;
                }
                return e;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class HashZipMapIter
    extends Iter<Map.Entry<byte[], byte[]>> {
        protected int zmEleLen;
        protected final RedisInputStream stream;

        private HashZipMapIter(RedisInputStream stream) {
            super(0L, null);
            this.stream = stream;
        }

        @Override
        public boolean hasNext() {
            try {
                this.zmEleLen = BaseRdbParser.LenHelper.zmElementLen(this.stream);
                return this.zmEleLen != 255;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Map.Entry<byte[], byte[]> next() {
            try {
                byte[] field = BaseRdbParser.StringHelper.bytes(this.stream, this.zmEleLen);
                this.zmEleLen = BaseRdbParser.LenHelper.zmElementLen(this.stream);
                if (this.zmEleLen == 255) {
                    return new AbstractMap.SimpleEntry<byte[], Object>(field, null);
                }
                int free = BaseRdbParser.LenHelper.free(this.stream);
                byte[] value = BaseRdbParser.StringHelper.bytes(this.stream, this.zmEleLen);
                BaseRdbParser.StringHelper.skip(this.stream, free);
                return new AbstractMap.SimpleEntry<byte[], byte[]>(field, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static abstract class Iter<T>
    implements Iterator<T> {
        protected long condition;
        protected final BaseRdbParser parser;

        private Iter(long condition, BaseRdbParser parser) {
            this.condition = condition;
            this.parser = parser;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

