/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.iterable;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.RdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.ContextKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.iterable.ValueIterableRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueByteArrayIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueMapEntryIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueZSetEntryIterator;
import java.io.IOException;
import java.util.Iterator;

public class ValueIterableRdbVisitor
extends DefaultRdbVisitor {
    public ValueIterableRdbVisitor(Replicator replicator) {
        this(replicator, new ValueIterableRdbValueVisitor(replicator));
    }

    public ValueIterableRdbVisitor(Replicator replicator, RdbValueVisitor valueParser) {
        super(replicator, valueParser);
    }

    @Override
    public Event applyList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o1 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o1.setValueRdbType(1);
        o1.setKey(key);
        o1.setValue((Iterator)this.valueVisitor.applyList(in, version));
        return context.valueOf(o1);
    }

    @Override
    public Event applySet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o2 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o2.setValueRdbType(2);
        o2.setKey(key);
        o2.setValue((Iterator)this.valueVisitor.applySet(in, version));
        return context.valueOf(o2);
    }

    @Override
    public Event applySetListPack(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o20 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o20.setValueRdbType(20);
        o20.setKey(key);
        o20.setValue((Iterator)this.valueVisitor.applySetListPack(in, version));
        return context.valueOf(o20);
    }

    @Override
    public Event applyZSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o3 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o3.setValueRdbType(3);
        o3.setKey(key);
        o3.setValue((Iterator)this.valueVisitor.applyZSet(in, version));
        return context.valueOf(o3);
    }

    @Override
    public Event applyZSet2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o5 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o5.setValueRdbType(5);
        o5.setKey(key);
        o5.setValue((Iterator)this.valueVisitor.applyZSet2(in, version));
        return context.valueOf(o5);
    }

    @Override
    public Event applyHash(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o4 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o4.setValueRdbType(4);
        o4.setKey(key);
        o4.setValue((Iterator)this.valueVisitor.applyHash(in, version));
        return context.valueOf(o4);
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o9 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o9.setValueRdbType(9);
        o9.setKey(key);
        o9.setValue((Iterator)this.valueVisitor.applyHashZipMap(in, version));
        return context.valueOf(o9);
    }

    @Override
    public Event applyListZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o10 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o10.setValueRdbType(10);
        o10.setKey(key);
        o10.setValue((Iterator)this.valueVisitor.applyListZipList(in, version));
        return context.valueOf(o10);
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o11 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o11.setValueRdbType(11);
        o11.setKey(key);
        o11.setValue((Iterator)this.valueVisitor.applySetIntSet(in, version));
        return context.valueOf(o11);
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o12 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o12.setValueRdbType(12);
        o12.setKey(key);
        o12.setValue((Iterator)this.valueVisitor.applyZSetZipList(in, version));
        return context.valueOf(o12);
    }

    @Override
    public Event applyZSetListPack(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueZSetEntryIterator o17 = new KeyStringValueZSetEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o17.setValueRdbType(17);
        o17.setKey(key);
        o17.setValue((Iterator)this.valueVisitor.applyZSetListPack(in, version));
        return context.valueOf(o17);
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o13 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o13.setValueRdbType(13);
        o13.setKey(key);
        o13.setValue((Iterator)this.valueVisitor.applyHashZipList(in, version));
        return context.valueOf(o13);
    }

    @Override
    public Event applyHashListPack(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueMapEntryIterator o16 = new KeyStringValueMapEntryIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o16.setValueRdbType(16);
        o16.setKey(key);
        o16.setValue((Iterator)this.valueVisitor.applyHashListPack(in, version));
        return context.valueOf(o16);
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o14 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o14.setValueRdbType(14);
        o14.setKey(key);
        o14.setValue((Iterator)this.valueVisitor.applyListQuickList(in, version));
        return context.valueOf(o14);
    }

    @Override
    public Event applyListQuickList2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        KeyStringValueByteArrayIterator o18 = new KeyStringValueByteArrayIterator();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        o18.setValueRdbType(18);
        o18.setKey(key);
        o18.setValue((Iterator)this.valueVisitor.applyListQuickList2(in, version));
        return context.valueOf(o18);
    }
}

