/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import com.moilioncircle.redis.replicator.util.ByteArray;
import java.util.Arrays;

public class Lzf {
    private static final int MAX_OFF = 8192;
    private static final int HASH_SIZE = 16384;
    private static final int MAX_LITERAL = 32;
    private static final int MAX_REF = 264;
    private static final ThreadLocal<long[]> BUFFER = ThreadLocal.withInitial(() -> new long[16384]);

    public static ByteArray decode(ByteArray bytes, long len) {
        ByteArray out = new ByteArray(len);
        Lzf.decode(bytes, 0L, out, 0L, len);
        return out;
    }

    private static void decode(ByteArray in, long inPos, ByteArray out, long outPos, long outEnd) {
        do {
            int ctrl;
            if ((ctrl = in.get(inPos++) & 0xFF) < 32) {
                switch (ctrl) {
                    case 31: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 30: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 29: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 28: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 27: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 26: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 25: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 24: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 23: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 22: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 21: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 20: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 19: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 18: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 17: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 16: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 15: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 14: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 13: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 12: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 11: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 10: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 9: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 8: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 7: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 6: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 5: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 4: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 3: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 2: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 1: {
                        out.set(outPos++, in.get(inPos++));
                    }
                    case 0: {
                        out.set(outPos++, in.get(inPos++));
                    }
                }
                continue;
            }
            long len = ctrl >> 5;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (len < 7L) {
                out.set(outPos, out.get(outPos++ + (long)(ctrl -= in.get(inPos++) & 0xFF)));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                switch ((int)len) {
                    case 6: {
                        out.set(outPos, out.get(outPos++ + (long)ctrl));
                    }
                    case 5: {
                        out.set(outPos, out.get(outPos++ + (long)ctrl));
                    }
                    case 4: {
                        out.set(outPos, out.get(outPos++ + (long)ctrl));
                    }
                    case 3: {
                        out.set(outPos, out.get(outPos++ + (long)ctrl));
                    }
                    case 2: {
                        out.set(outPos, out.get(outPos++ + (long)ctrl));
                    }
                    case 1: {
                        out.set(outPos, out.get(outPos++ + (long)ctrl));
                    }
                }
                continue;
            }
            len = in.get(inPos++) & 0xFF;
            if ((long)(ctrl -= in.get(inPos++) & 0xFF) + len < -9L) {
                if ((len += 9L) <= 32L) {
                    long inPos1 = outPos + (long)ctrl;
                    long outPos1 = outPos;
                    switch ((int)len - 1) {
                        case 31: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 30: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 29: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 28: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 27: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 26: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 25: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 24: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 23: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 22: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 21: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 20: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 19: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 18: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 17: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 16: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 15: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 14: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 13: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 12: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 11: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 10: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 9: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 8: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 7: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 6: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 5: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 4: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 3: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 2: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 1: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                        case 0: {
                            out.set(outPos1++, out.get(inPos1++));
                        }
                    }
                } else {
                    ByteArray.arraycopy(out, outPos + (long)ctrl, out, outPos, len);
                }
                outPos += len;
                continue;
            }
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            out.set(outPos, out.get(outPos++ + (long)ctrl));
            long end = (len += outPos) - 3L;
            while (outPos < end) {
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
            }
            if (len - outPos == 3L) {
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                continue;
            }
            if (len - outPos == 2L) {
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                out.set(outPos, out.get(outPos++ + (long)ctrl));
                continue;
            }
            if (len - outPos != 1L) continue;
            out.set(outPos, out.get(outPos++ + (long)ctrl));
        } while (outPos < outEnd);
        if (outPos != outEnd) {
            throw new AssertionError((Object)("corrupt data: overrun in decompress, input offset " + inPos + ", output offset " + outPos));
        }
    }

    public static ByteArray encode(ByteArray bytes) {
        long len = bytes.length();
        ByteArray out = new ByteArray(len - 3L);
        if ((len = Lzf.encode(bytes, len, out, 0L)) <= 0L) {
            return bytes;
        }
        ByteArray r = new ByteArray(len);
        ByteArray.arraycopy(out, 0L, r, 0L, len);
        return r;
    }

    public static long encode(ByteArray in, long inLen, ByteArray out, long outPos) {
        try {
            int inPos = 0;
            long outLen = outPos + out.length() - 1L;
            long[] hashTab = BUFFER.get();
            Arrays.fill(hashTab, 0L);
            int literals = 0;
            ++outPos;
            int future = Lzf.first(in, 0L);
            while ((long)inPos < inLen - 4L) {
                byte p2 = in.get(inPos + 2);
                future = (future << 8) + (p2 & 0xFF);
                int off = Lzf.hash(future);
                long ref = hashTab[off];
                hashTab[off] = inPos;
                if (ref < (long)inPos && ref > 0L && (off = (int)((long)inPos - ref - 1L)) < 8192 && in.get(ref + 2L) == p2 && in.get(ref + 1L) == (byte)(future >> 8) && in.get(ref) == (byte)(future >> 16)) {
                    long maxLen = inLen - (long)inPos - 2L;
                    if (maxLen > 264L) {
                        maxLen = 264L;
                    }
                    if (outPos + 3L + 1L >= outLen) {
                        int c;
                        int n = c = literals == 0 ? 1 : 0;
                        if (outPos - (long)c + 3L + 1L >= outLen) {
                            return 0L;
                        }
                    }
                    if (literals == 0) {
                        --outPos;
                    } else {
                        out.set(outPos - (long)literals - 1L, (byte)(literals - 1));
                        literals = 0;
                    }
                    int len = 3;
                    while ((long)len < maxLen && in.get(ref + (long)len) == in.get(inPos + len)) {
                        ++len;
                    }
                    if ((len -= 2) < 7) {
                        out.set(outPos++, (byte)((off >> 8) + (len << 5)));
                    } else {
                        out.set(outPos++, (byte)((off >> 8) + 224));
                        out.set(outPos++, (byte)(len - 7));
                    }
                    out.set(outPos++, (byte)off);
                    ++outPos;
                    future = Lzf.first(in, inPos += len);
                    future = Lzf.next(future, in, inPos);
                    hashTab[Lzf.hash((int)future)] = inPos++;
                    future = Lzf.next(future, in, inPos);
                    hashTab[Lzf.hash((int)future)] = inPos++;
                    continue;
                }
                if (outPos >= outLen) {
                    return 0L;
                }
                out.set(outPos++, in.get(inPos++));
                if (++literals != 32) continue;
                out.set(outPos - (long)literals - 1L, (byte)(literals - 1));
                literals = 0;
                ++outPos;
            }
            if (outPos + 3L > outLen) {
                return 0L;
            }
            while ((long)inPos < inLen) {
                out.set(outPos++, in.get(inPos++));
                if (++literals != 32) continue;
                out.set(outPos - (long)literals - 1L, (byte)(literals - 1));
                literals = 0;
                ++outPos;
            }
            out.set(outPos - (long)literals - 1L, (byte)(literals - 1));
            if (literals == 0) {
                --outPos;
            }
            return outPos;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0L;
        }
    }

    private static int first(ByteArray in, long inPos) {
        return in.get(inPos) << 8 | in.get(inPos + 1L) & 0xFF;
    }

    private static int next(int v, ByteArray in, long inPos) {
        return v << 8 | in.get(inPos + 2L) & 0xFF;
    }

    private static int hash(int h) {
        return h * 2777 >> 9 & 0x3FFF;
    }
}

