/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import com.moilioncircle.redis.replicator.util.Arrays;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class Strings {
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(Object object) {
        return Strings.toString(object, StandardCharsets.UTF_8);
    }

    public static String toString(Object object, Charset charset) {
        if (object == null) {
            return null;
        }
        return new String((byte[])object, charset);
    }

    public static boolean isEquals(String o1, String o2) {
        return Strings.isEquals(o1, o2, false);
    }

    public static boolean isEquals(String o1, String o2, boolean strict) {
        Objects.requireNonNull(o1);
        Objects.requireNonNull(o2);
        return strict ? o1.equals(o2) : o1.equalsIgnoreCase(o2);
    }

    public static String format(Object[] command) {
        return Arrays.deepToString(command, "[", "]", " ");
    }

    public static final String lappend(int src, int length, char padding) {
        return Strings.lappend(String.valueOf(src), length, padding);
    }

    public static final String lappend(long src, int length, char padding) {
        return Strings.lappend(String.valueOf(src), length, padding);
    }

    public static final String lappend(String s, int length, char padding) {
        if (s != null && s.length() >= length) {
            return s;
        }
        s = s == null ? "" : s;
        StringBuilder r = new StringBuilder(length);
        for (int i = s.length(); i < length; ++i) {
            r.append(padding);
        }
        r.append(s);
        return r.toString();
    }

    public static ByteBuffer encode(CharBuffer buffer) {
        return Strings.encode(StandardCharsets.UTF_8, buffer);
    }

    public static CharBuffer decode(ByteBuffer buffer) {
        return Strings.decode(StandardCharsets.UTF_8, buffer);
    }

    public static ByteBuffer encode(Charset charset, CharBuffer buffer) {
        return charset.encode(buffer);
    }

    public static CharBuffer decode(Charset charset, ByteBuffer buffer) {
        return charset.decode(buffer);
    }

    public static String mask(String password) {
        if (password == null) {
            return "mask(password)";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return Strings.bytesToHex(digest.digest(password.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            return "mask(password)";
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] ary = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            ary[j * 2] = HEX_ARRAY[v >>> 4];
            ary[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(ary);
    }
}

