package com.moloco.sdk.acm

/**
 * Provides constant values for ACM (Android Client Metrics) request headers.
 *
 * These constants represent the standard header keys used when making ACM-related network requests.
 * They can be used to ensure consistency between SDK and Client Metrics.
 */
object AcmHeaders {
    // Mediator
    const val MEDIATOR = "Mediator"

    // Header key for operating system information version.
    const val OS_VERSION = "osv"

    // Header key for operating system information.
    const val OS = "OS"

    // Header key for application key.
    const val APP_KEY = "AppKey"

    // Header key for application bundle identifier.
    const val APP_BUNDLE = "AppBundle"

    // Header key for application version.
    const val APP_VERSION = "AppVersion"

    // Header key for sdk version.
    const val MOLOCO_SDK_VERSION = "SdkVersion"
}
