package com.moloco.sdk.acm

import android.content.Context
import com.moloco.sdk.acm.eventprocessing.DefaultDataTimeConfigurations.REQUEST_POLLING_INTERVAL_SECONDS

/**
 * Data class representing the active configuration for Moloco Analytics library.
 *
 * @property appId The application ID associated with the currently running application.
 * @property postAnalyticsUrl The URL where metrics are posted.
 * @property requestPeriodSeconds The interval at which a metrics request will be made.
 * @property clientOptions A map of additional options (key-value pairs) related to analytics.
 */
internal data class ACMConfig(
    val appId: String,
    var postAnalyticsUrl: String, // This can be changed at runtime via app/sdk using [UpdateConfig]
    var requestPeriodSeconds: Long = REQUEST_POLLING_INTERVAL_SECONDS, // This can be changed at runtime via app/sdk using [UpdateConfig]
    val clientOptions: Map<String, String>
)

/**
 * Data class representing the configuration for Moloco Analytics initialization.
 *
 * @property appId The application ID associated with the currently running application.
 * @property postAnalyticsUrl The URL where metrics are posted.
 * @property requestPeriodSeconds The interval at which a metrics request will be made.
 * @property clientOptions A map of additional options (key-value pairs) related to analytics.
 */
data class InitConfig(
    val appId: String,
    val postAnalyticsUrl: String,
    val context: Context,
    val requestPeriodSeconds: Long = REQUEST_POLLING_INTERVAL_SECONDS,
    val clientOptions: Map<String, String>
)

internal fun InitConfig.toACMConfig(): ACMConfig {
    return ACMConfig(appId, postAnalyticsUrl, requestPeriodSeconds, clientOptions)
}

/**
 * Calling client app/sdk of the ACM library can update ACM configurations
 * at runtime dynamically to change the behavior of the library.
 */
data class UpdateConfig(
    val postAnalyticsUrl: String? = null,
    val requestPeriodSeconds: Long? = null
)
