package com.moloco.sdk.acm.services

import java.util.concurrent.atomic.AtomicLong

/**
 * Class representing a stopwatch for measuring operational metrics.
 */
internal class Stopwatch(private val timeProviderService : TimeProviderService) {
    /**
     * The start time of the stopwatch in milliseconds.
     */
    val startTime = AtomicLong(0)

    /**
     * Starts the stopwatch by setting the start time to the current system time in milliseconds.
     */
    fun start() {
        startTime.set(timeProviderService())
    }

    /**
     * Ends the stopwatch and returns the elapsed time in milliseconds since the stopwatch was started.
     *
     * @return The elapsed time in milliseconds.
     */
    fun end(): Long {
        return timeProviderService() - startTime.get()
    }
}
