package com.moloco.sdk.acm.services

/**
 * Service to provide current time for Analytics stopwatch.
 */
internal interface TimeProviderService {
    /**
     * @return the difference, measured in milliseconds, between the current time and midnight, January 1, 1970 UTC.
     */
    operator fun invoke(): Long
}

internal class TimeProviderServiceImpl : TimeProviderService {
    override fun invoke(): Long = System.currentTimeMillis()
}
