package com.moloco.sdk.acm.db

import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.TypeConverter
import androidx.room.TypeConverters

enum class EventType {
    TIMER,
    COUNT
}

@Entity(tableName = "events")
@TypeConverters(Converters::class)
internal data class EventEntity(
    @PrimaryKey(autoGenerate = true)
    val id: Long = 0,
    val name: String,
    val timestamp: Long,
    val eventType: EventType,            // Can be "TIMER" or "COUNT"
    val data: Long? = null,              // For count and timer data
    val tags: List<String> = emptyList()
)

class Converters {
    @TypeConverter
    fun fromEventType(eventType: EventType): String {
        return eventType.name
    }

    @TypeConverter
    fun toEventType(eventType: String): EventType {
        return EventType.valueOf(eventType)
    }

    @TypeConverter
    fun fromTagList(tags: List<String>): String {
        return tags.joinToString(separator = ",")
    }

    @TypeConverter
    fun toTagList(tagsString: String): List<String> {
        return if (tagsString.isEmpty()) {
            emptyList()
        } else {
            tagsString.split(",")
        }
    }
}
