package com.moloco.sdk.acm.db

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters

@Database(
    entities = [EventEntity::class],
    version = 1
)
@TypeConverters(Converters::class)
internal abstract class MetricsDb : RoomDatabase() {
    abstract fun operationalMetricsDao(): MetricsDAO
    companion object {
        @Volatile
        private var instance: MetricsDb? = null
        internal const val TAG = "MetricsDb"

        fun getInstance(context: Context): MetricsDb {
            return instance ?: synchronized(this) {
                instance ?: buildDatabase(context).also { instance = it }
            }
        }

        private fun buildDatabase(context: Context): MetricsDb {
            return try {
                Room.databaseBuilder(
                    context.applicationContext,
                    MetricsDb::class.java,
                    "metrics-db"
                ).build()
            } catch(e: Exception) {
                throw IllegalStateException("Database creation failed", e)
            }
        }
    }
}
