package com.moloco.sdk.acm.eventprocessing

import com.moloco.sdk.acm.db.EventEntity
import com.moloco.sdk.acm.services.TimeProviderService

/**
 * Class responsible for checking the age of an event.
 *
 * This class provides functionality to determine whether an event is older
 * than a specified age by comparing the event's timestamp with the current time
 * provided by a `TimeProviderService`.
 *
 * @property timeProviderService The service used to provide the current time.
 * @property ageSeconds The age in seconds to compare against.
 */
internal class DataAgeChecker(private val timeProviderService: TimeProviderService,
                              private val ageSeconds: Long) {
    /**
     * Checks if the given event is older than the specified age in milliseconds.
     *
     * This method compares the event's timestamp to the current time and determines
     * if the event's age is greater than or equal to the specified age.
     *
     * @param eventEntity The event to check.
     * @return `true` if the event is older than or equal to the specified age, `false` otherwise.
     */
    fun isEventOutdated(eventEntity: EventEntity): Boolean {
        // converts data age in seconds to millis
        return timeProviderService() - eventEntity.timestamp >= ageSeconds * 1000
    }
}
