package com.moloco.sdk.acm.eventprocessing

/**
 * Configurations that if not received from proto should be default to ACM.
 * Values are in seconds
 */
internal object DefaultDataTimeConfigurations {
    /**
     * Value to represent request and database purge time for the ACM library
     */
    const val REQUEST_POLLING_INTERVAL_SECONDS: Long = 600L // 10 minutes

    /**
     * Value to represent the max age events should be in order to be sent in an ACM request
     */
    const val DATA_AGE_SECONDS: Long = 720L // 12 minutes
}
