package com.moloco.sdk.acm.http

import io.ktor.client.HttpClient
import io.ktor.client.plugins.HttpTimeout
import io.ktor.client.plugins.UserAgent

/**
 * Provides an instance of HttpClient configured with necessary installations.
 *
 * @return Configured instance of HttpClient.
 */
fun metricsHttpClient() : HttpClient = Instance

/**
 * Lazily initializes and configures an instance of HttpClient.
 */
// TODO: install HttpRequestRetry and have configurable backoff with 5xx response
private val Instance by lazy {
    HttpClient {
        install(UserAgent)
        install(HttpTimeout)
    }
}

/**
 * Object to allow for PostMetricsRequest http client since we cannot pass this through
 * our WorkManager.
 */
internal object HttpClientSingleton {
    private lateinit var httpClient: HttpClient
    private lateinit var apiUrl: String

    fun initialize(httpClient: HttpClient, apiUrl: String) {
        if (!::httpClient.isInitialized) {
            this.httpClient = httpClient
            this.apiUrl = apiUrl
        }
    }

    val postMetricsRequest: PostMetricsRequest by lazy {
        PostMetricsRequestImpl(httpClient, apiUrl)
    }
}
