package com.moloco.sdk.acm

/**
 * Data class representing a tag associated with an analytics event.
 *
 * @property key The key of the tag.
 * @property value The value of the tag.
 */
data class EventTag(val key: String, val value: String)

fun EventTag.toKeyValueString(): String {
    return "$key:$value"
}
