package com.moloco.sdk.acm

import android.content.Context

/**
 * Data class representing the configuration for Moloco Analytics initialization.
 *
 * @property appId The application ID associated with the currently running application.
 * @property postAnalyticsUrl The URL where metrics are posted.
 * @property context The application context.
 * @property requestPeriodSeconds The interval at which a metrics request will be made.
 * @property clientOptions A map of additional options (key-value pairs) related to analytics.
 */
data class InitConfig(
    val appId: String,
    val postAnalyticsUrl: String,
    val context: Context,
    val requestPeriodSeconds: Long,
    val clientOptions: Map<String, String>
)
