package com.moloco.sdk.internal

import android.content.Context
import com.moloco.sdk.Init.SDKInitResponse
import com.moloco.sdk.acm.AndroidClientMetrics
import com.moloco.sdk.internal.ortb.BidResponseParser
import com.moloco.sdk.internal.publisher.AdCreateLoadTimeoutManager
import com.moloco.sdk.internal.publisher.BidLoader
import com.moloco.sdk.internal.publisher.InterstitialAd
import com.moloco.sdk.internal.publisher.RewardedInterstitialAd
import com.moloco.sdk.internal.publisher.createBase64GzippedBidProcessor
import com.moloco.sdk.internal.publisher.nativead.NativeAdAssetsProvider
import com.moloco.sdk.internal.publisher.nativead.NativeAdImpl
import com.moloco.sdk.internal.publisher.nativead.NativeAdLoader
import com.moloco.sdk.internal.publisher.nativead.parser.NativeAdOrtbResponseParser
import com.moloco.sdk.internal.services.AnalyticsApplicationLifecycleTracker
import com.moloco.sdk.internal.services.AudioService
import com.moloco.sdk.internal.services.ClickthroughService
import com.moloco.sdk.internal.services.TimeProviderService
import com.moloco.sdk.publisher.Banner
import com.moloco.sdk.publisher.InterstitialAd
import com.moloco.sdk.publisher.NativeAd
import com.moloco.sdk.publisher.RewardedInterstitialAd
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.Ad
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.vastAdPlaylistController
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

internal interface AdFactory {
    fun createBanner(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
            viewLifecycleOwnerSingleton: ViewLifecycleOwner,
            bannerSize: BannerSize
    ): Banner

    fun createBannerTablet(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
            viewLifecycleOwnerSingleton: ViewLifecycleOwner,
            bannerSize: BannerSize
    ): Banner

    fun createMREC(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
            viewLifecycleOwnerSingleton: ViewLifecycleOwner,
            bannerSize: BannerSize
    ): Banner

    fun createInterstitial(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            persistentHttpRequest: PersistentHttpRequest,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager
    ): InterstitialAd

    fun createRewardedInterstitial(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            persistentHttpRequest: PersistentHttpRequest,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager
    ): RewardedInterstitialAd

    fun createNativeAd(
        context: Context,
        appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
        audioService: AudioService,
        adUnitId: String,
        viewVisibilityTracker: ViewVisibilityTracker,
        externalLinkHandler: ExternalLinkHandler,
        persistentHttpRequest: PersistentHttpRequest,
        viewLifecycleOwnerSingleton: ViewLifecycleOwner,
        watermark: Watermark,
        adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
        timeProvider: TimeProviderService,
    ): NativeAd
}

internal class AdFactoryImpl(
    private val initResponse: SDKInitResponse,
    private val customUserEventBuilderService: CustomUserEventBuilderService,
    private val clickthroughService: ClickthroughService
) : AdFactory {
    private val verifyBannerVisible by lazy { initResponse.verifyBannerVisible }

    override fun createBanner(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
            viewLifecycleOwnerSingleton: ViewLifecycleOwner,
            bannerSize: BannerSize
    ): Banner = com.moloco.sdk.internal.publisher.BannerView(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        externalLinkHandler,
        watermark,
        adCreateLoadTimeoutManager,
        viewLifecycleOwnerSingleton,
        bannerSize,
        clickthroughService
    )

    override fun createBannerTablet(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
            viewLifecycleOwnerSingleton: ViewLifecycleOwner,
            bannerSize: BannerSize
    ): Banner = com.moloco.sdk.internal.publisher.BannerView(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        externalLinkHandler,
        watermark,
        adCreateLoadTimeoutManager,
        viewLifecycleOwnerSingleton,
        bannerSize,
        clickthroughService
    )

    override fun createMREC(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
            viewLifecycleOwnerSingleton: ViewLifecycleOwner,
            bannerSize: BannerSize
    ): Banner = com.moloco.sdk.internal.publisher.BannerView(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        externalLinkHandler,
        watermark,
        adCreateLoadTimeoutManager,
        viewLifecycleOwnerSingleton,
        bannerSize,
        clickthroughService
    )

    override fun createNativeAd(
        context: Context,
        appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
        audioService: AudioService,
        adUnitId: String,
        viewVisibilityTracker: ViewVisibilityTracker,
        externalLinkHandler: ExternalLinkHandler,
        persistentHttpRequest: PersistentHttpRequest,
        viewLifecycleOwnerSingleton: ViewLifecycleOwner,
        watermark: Watermark,
        adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
        timeProvider: TimeProviderService,
    ): NativeAd  {
        fun createVastController(
            vastAd: Ad,
        ) = vastAdPlaylistController(
            ad = vastAd,
            externalLinkHandler = externalLinkHandler,
            context = context,
            mute = true,
            overrideLinearGoNextActionEnabled = false,
            overrideLinearGoNextActionEnabledDelaySeconds = 0,
            companionGoNextActionDelaySeconds = 0,
            decGoNextActionDelaySeconds = 0,
            autoStoreOnComplete = false,
            autoStoreOnSkip = false,
            customUserEventBuilderService = customUserEventBuilderService
        )

        val nativeAdLoader = NativeAdLoader(
            context,
            adUnitId,
            BidLoader(BidResponseParser(), createBase64GzippedBidProcessor()),
            NativeAdOrtbResponseParser(),
            adCreateLoadTimeoutManager,
            AndroidClientMetrics,
            timeProvider)

        val nativeAdAssetsProvider = NativeAdAssetsProvider(
            context,
            viewVisibilityTracker,
            viewLifecycleOwnerSingleton,
            watermark,
            ::createVastController
        )

        return NativeAdImpl(
            adUnitId,
            nativeAdLoader,
            nativeAdAssetsProvider,
            appLifecycleTrackerService,
            customUserEventBuilderService,
            externalLinkHandler,
            persistentHttpRequest,
            adCreateLoadTimeoutManager,
        )
    }

    override fun createInterstitial(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            persistentHttpRequest: PersistentHttpRequest,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
    ): InterstitialAd = InterstitialAd(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        externalLinkHandler = externalLinkHandler,
        persistentHttpRequest = persistentHttpRequest,
        watermark = watermark,
        adCreateLoadTimeoutManager = adCreateLoadTimeoutManager,
    )

    override fun createRewardedInterstitial(
            context: Context,
            appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
            adUnitId: String,
            viewVisibilityTracker: ViewVisibilityTracker,
            externalLinkHandler: ExternalLinkHandler,
            persistentHttpRequest: PersistentHttpRequest,
            watermark: Watermark,
            adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager
    ): RewardedInterstitialAd = RewardedInterstitialAd(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        externalLinkHandler = externalLinkHandler,
        persistentHttpRequest = persistentHttpRequest,
        watermark = watermark,
        adCreateLoadTimeoutManager = adCreateLoadTimeoutManager,
    )
}

/**
 * The constant string representing the test ad unit id
 */
const val MOLOCO_TEST_AD_UNIT_ID = "moloco_test_placement"
