package com.moloco.sdk.internal.ilrd

/**
 * Represents the possible states of an ILRD provider.
 * Used to track subscription status and handle errors.
 */
sealed class IlrdState {
    /**
     * Provider is successfully subscribed and actively providing impression events.
     */
    object Subscribed : IlrdState()

    /**
     * Provider is not currently subscribed to impression events.
     */
    object Unsubscribed : IlrdState()

    /**
     * Provider encountered an error during subscription or operation.
     * @property reason Description of the error that occurred
     */
    data class Error(val reason: String) : IlrdState()
}
