package com.moloco.sdk.internal.publisher

import com.moloco.sdk.internal.MolocoInternalAdError
import com.moloco.sdk.internal.ortb.model.SdkEvents
import com.moloco.sdk.publisher.MolocoAd

/**
 * Internal listener interface for ad load events.
 */
internal interface InternalAdLoadListener {
    /**
     * Invoked when the ad starts loading
     *
     * @param molocoAd The [MolocoAd] instance that contains information about the ad
     *
     * TODO: Make SdkEvents non null. https://mlc.atlassian.net/browse/SDK-3123
     */
    fun onAdLoadStarted(molocoAd: MolocoAd, timestamp: Long, sdkEvents: SdkEvents?)

    /**
     * Invoked when the ad is loaded successfully
     *
     * @param molocoAd The [MolocoAd] instance that contains information about the ad
     *
     * TODO: Make SdkEvents non null. https://mlc.atlassian.net/browse/SDK-3123
     */
    fun onAdLoadSuccess(molocoAd: MolocoAd, sdkEvents: SdkEvents?)

    /**
     * Invoked when an error occurs during ad loading
     *
     * @param internalError The [MolocoInternalAdError] instance that contains information about the error
     *
     * TODO: Make SdkEvents non null. https://mlc.atlassian.net/browse/SDK-3123
     */
    fun onAdLoadFailed(internalError: MolocoInternalAdError, sdkEvents: SdkEvents?)
}
