package com.moloco.sdk.internal.publisher.nativead.ui

import android.annotation.SuppressLint
import android.content.Context
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.annotation.VisibleForTesting
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.ComposeView
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.ViewLifecycleOwner
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdController
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.OverrideVastContainerOnClick
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.VastRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.defaultPlaybackControl

@SuppressLint("ViewConstructor")
internal class NativeAdVideoContainer(
    context: Context,
    private val vastAdController: AdController,
    viewVisibilityTracker: ViewVisibilityTracker,
    private val viewLifecycleOwner: ViewLifecycleOwner,
    watermark: Watermark,
    onClick: (() -> Unit)?,
) : FrameLayout(context) {

    override fun onWindowFocusChanged(hasWindowFocus: Boolean) {
        super.onWindowFocusChanged(hasWindowFocus)
        /**
         * If opened in a dialog, this creates a new Window, so we listen the the new Window state
         */
        if (hasWindowFocus) {
            viewLifecycleOwner.resume(this)
        } else {
            viewLifecycleOwner.pause(this)
        }
    }

    @VisibleForTesting(otherwise = VisibleForTesting.PROTECTED)
    public override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        MolocoLogger.info(TAG, "onAttachedToWindow")
        viewLifecycleOwner.addLifecycleOwnerSupportTo(this)
    }

    @VisibleForTesting(otherwise = VisibleForTesting.PROTECTED)
    public override fun onDetachedFromWindow() {
        super.onDetachedFromWindow()
        MolocoLogger.info(TAG, "onDetachedFromWindow")
        viewLifecycleOwner.removeLifecycleOwnerSupportFrom(this)
    }

    @VisibleForTesting
    var videoView: ComposeView? = NativeAdComposeViewWrapper(context) { modifier ->
        watermark.ApplyWatermark {
            VastRenderer(
                modifier = modifier,
                adViewModel = vastAdController,
                backgroundColor = Color.Black,
                adCloseCountdownButton = null,
                adSkipCountdownButton = null,
                ctaButton = null,
                overrideVastContainerOnClick = OverrideVastContainerOnClick(
                    overrideLinearOnClick = onClick,
                    overrideCompanionOnClick = onClick,
                    overrideDECOnClick = onClick
                ),
                progressBar = null,
                muteButton = nativeVideoMuteButton(),
                playbackControl = defaultPlaybackControl(
                    NativeVideoPlaybackControlUI
                ),
                viewVisibilityTracker = viewVisibilityTracker
            )
        }
    }.also {
        addView(it, ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))
    }

    fun destroy() {
        vastAdController.destroy()
        destroyUnderlyingVideoComposeView()
    }

    private fun destroyUnderlyingVideoComposeView() {
        removeAllViews()
        videoView?.disposeComposition()
        videoView = null
    }

    companion object {
        private const val TAG = "VideoContainer"
    }
}
