package com.moloco.sdk.internal.scheduling

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

/**
 * Executes the given block of code on the UI thread. If the current thread is the UI thread,
 * the block is executed immediately. Otherwise, it is posted to the UI handler for execution.
 *
 * @param block The block of code to be executed on the UI thread.
 */
internal fun runOnMainDispatcher(block: () -> Unit) = uiScope.launch {
    block()
}

private val uiScope = CoroutineScope(DispatcherProvider().mainImmediate)
