package com.moloco.sdk.internal.services

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.ScreenService

/**
 * Duplicate functionality to [ScreenService]. The default implementation just forwards calls to
 * [ScreenService].
 *
 * TODO - Remove [ScreenService] and use this class - https://mlc.atlassian.net/browse/SDK-2355
 * All service objects should be in SDK module (not xenoss renderer)
 */
internal interface ScreenInfoService {
    @Deprecated("Use screenInfo() instead")
    operator fun invoke(): ScreenInfo

    fun screenInfo(): ScreenInfo

    fun orientation(): ScreenOrientation
}

internal enum class ScreenOrientation {
    UNKNOWN,
    PORTRAIT,
    LANDSCAPE,
    ;
}

internal data class ScreenInfo(
    val screenWidthPx: Int,
    val screenWidthDp: Float,
    val screenHeightPx: Int,
    val screenHeightDp: Float,
    val density: Float,
    val dpi: Int,
    val xdpi: Float,
    val ydpi: Float,
)

internal class ScreenInfoServiceImpl(val context: Context) : ScreenInfoService {
    @Deprecated("Use screenInfo() instead", replaceWith = ReplaceWith("screenInfo()"))
    override fun invoke(): ScreenInfo = screenInfo()

    override fun screenInfo(): ScreenInfo = ScreenService(context).invoke().let {
        ScreenInfo(
            screenWidthDp = it.widthDp,
            screenWidthPx = it.widthPx,
            screenHeightDp = it.heightDp,
            screenHeightPx = it.heightPx,
            density = it.pxRatio,
            dpi = it.dpi,
            xdpi = context.resources.displayMetrics.xdpi,
            ydpi = context.resources.displayMetrics.ydpi,
        )
    }

    override fun orientation(): ScreenOrientation {
        // Retrieve screen orientation
        return when (context.resources.configuration.orientation) {
            android.content.res.Configuration.ORIENTATION_PORTRAIT -> ScreenOrientation.PORTRAIT
            android.content.res.Configuration.ORIENTATION_LANDSCAPE -> ScreenOrientation.LANDSCAPE
            else -> ScreenOrientation.UNKNOWN
        }
    }
}
