package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.BatteryInfoService

/**
 * The battery information that's needed to construct the bid token
 */
internal data class BatteryInfoSignal(
    val maxBatteryLevel: Int? = null,
    val batteryStatus: Int? = null,
    val isPowerSaveMode: Boolean? = null
)

/**
 * This class provides the battery information signal
 */
internal class BatteryInfoSignalProvider(private val batteryInfoService: BatteryInfoService): ClientBidTokenSignalProvider<BatteryInfoSignal> {
    private var cachedSignal = getBatteryInfoSignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getBatteryInfoSignal()
        val needsRefresh = cachedSignal != currentSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT][BIS]: needsRefresh: $needsRefresh")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedSignal = getBatteryInfoSignal()
    }

    override fun provideSignal(): BatteryInfoSignal = cachedSignal

    override fun logTag(): String = TAG

    private fun getBatteryInfoSignal(): BatteryInfoSignal {
        try {
            return BatteryInfoSignal(
                maxBatteryLevel = batteryInfoService.maxBatteryLevel(),
                batteryStatus = batteryInfoService.batteryStatus(),
                isPowerSaveMode = batteryInfoService.isLowerPowerModeEnabled()
            ).apply {
                MolocoLogger.debugBuildLog(TAG, "[CBT][BIS]: blev: $maxBatteryLevel, bst: $batteryStatus, psm: $isPowerSaveMode")
            }
        } catch (e: Exception) {
            MolocoLogger.error(TAG, "[CBT][BIS]: Error", e)
            return BatteryInfoSignal()
        }
    }

    companion object {
        private const val TAG = "BInfoSignalProvider"
    }

}
