package com.moloco.sdk.internal.services.bidtoken.providers

import android.app.ActivityManager
import android.app.ActivityManager.MemoryInfo
import com.moloco.sdk.internal.MolocoLogger

/**
 * Signal provider for memory information
 */
internal data class MemoryInfoSignal(
    val lowMemory: Boolean?= null,
    val threshold: Long?= null,
    val totalMem: Long? = null,
)
internal class MemorySignalProvider(private val activityManager: ActivityManager) :
    ClientBidTokenSignalProvider<MemoryInfoSignal> {

    private var cachedMemorySignal: MemoryInfoSignal = getMemoryInfo()

    override fun needsRefresh(): Boolean {
        val currentMemorySignal = getMemoryInfo()
        MolocoLogger.debugBuildLog(TAG, "[CBT] cached lm: ${cachedMemorySignal.lowMemory}, t: ${cachedMemorySignal.threshold}, tm: ${cachedMemorySignal.totalMem}")
        MolocoLogger.debugBuildLog(TAG, "[CBT] current lm: ${currentMemorySignal.lowMemory}, t: ${currentMemorySignal.threshold}, tm: ${currentMemorySignal.totalMem}")
        val needsRefresh = currentMemorySignal.isDifferent(cachedMemorySignal)
        MolocoLogger.debugBuildLog(TAG, "[CBT] m needsRefresh: $needsRefresh")
        return needsRefresh
    }

    private fun MemoryInfoSignal.isDifferent(other: MemoryInfoSignal): Boolean {
        return this.lowMemory != other.lowMemory ||
                this.threshold != other.threshold ||
                this.totalMem != other.totalMem
    }

    override fun tryUpdateSignalState() {
        MolocoLogger.debugBuildLog(TAG, "[CBT] Updating m state")
        cachedMemorySignal = getMemoryInfo()
    }

    override fun provideSignal(): MemoryInfoSignal {
        return cachedMemorySignal.apply {
            MolocoLogger.debugBuildLog(TAG, "[CBT] lm: $lowMemory, t: $threshold, tm: $totalMem")
        }
    }

    override fun logTag(): String = TAG

    private fun getMemoryInfo(): MemoryInfoSignal {
        return try {
            MemoryInfo().apply {
                activityManager.getMemoryInfo(this)
            }.run { MemoryInfoSignal(lowMemory, threshold, totalMem) }
        } catch (e: Exception) {
            MolocoLogger.error(TAG, "[CBT] MI Error", e)
            MemoryInfoSignal()
        }
    }

    companion object {
        private const val TAG = "MemorySignalProvider"
    }
}
