package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.NetworkInfo
import com.moloco.sdk.internal.services.NetworkInfoService

/**
 * Network signals needed for client bid token generation.
 */
internal data class NetworkInfoSignal(
    val mobileCountryCode: Int? = null,
    val mobileNetworkCode: Int? = null,
    val networkRestricted: Boolean? = null,
    val networkType: NetworkInfo? = null,
)

/**
 * Signal provider for network information.
 */
internal class NetworkInfoSignalProvider(private val networkInfoService: NetworkInfoService) : ClientBidTokenSignalProvider<NetworkInfoSignal> {
    private var cachedNetworkSignal = getNetworkInfoSignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getNetworkInfoSignal()
        val needsRefresh = currentSignal != cachedNetworkSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT] NIS needsRefresh: $needsRefresh, with nis: $currentSignal, cached: $cachedNetworkSignal")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedNetworkSignal = getNetworkInfoSignal()
    }

    override fun provideSignal(): NetworkInfoSignal {
        return cachedNetworkSignal
    }

    override fun logTag(): String = TAG

    private fun getNetworkInfoSignal(): NetworkInfoSignal = try { NetworkInfoSignal(
        mobileCountryCode = networkInfoService.mobileCountryCode(),
        mobileNetworkCode = networkInfoService.mobileNetworkCode(),
        networkRestricted = networkInfoService.isOnMeteredNetworkRestrictions(),
        networkType = networkInfoService.networkInfo()
    ).apply {
        MolocoLogger.debugBuildLog(TAG, "[CBT] NIS providing $this")
    }
    } catch (e: Exception) {
        MolocoLogger.error(TAG, "[CBT] NIS Error", e)
        NetworkInfoSignal()
    }

    companion object {
        private const val TAG = "NISignalProvider"
    }
}
