package com.moloco.sdk.internal.services.events

import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventConfigService

private data class UserEventConfig(
    val eventReportingEnabled: Boolean,
    val userTrackingEnabled: Boolean,
    val appForegroundUrl: String,
    val appBackgroundUrl: String,
)

private val defaultUserEventConfig = UserEventConfig(
    eventReportingEnabled = false,
    userTrackingEnabled = false,
    appForegroundUrl = "",
    appBackgroundUrl = ""
)

internal class CustomUserEventConfigServiceImpl : CustomUserEventConfigService {
    private var config: UserEventConfig = defaultUserEventConfig

    override fun configure(
        eventCollectionEnabled: Boolean,
        userTrackingEnabled: Boolean,
        appForegroundUrl: String,
        appBackgroundUrl: String,
    ) {
        config = UserEventConfig(
            eventReportingEnabled = eventCollectionEnabled,
            userTrackingEnabled = userTrackingEnabled,
            appForegroundUrl = appForegroundUrl,
            appBackgroundUrl = appBackgroundUrl
        )
    }

    override fun isUserTrackingEnabled(): Boolean = config.userTrackingEnabled

    override fun isCustomUserEventReportingEnabled(): Boolean = config.eventReportingEnabled

    override fun applicationForegroundUrl(): String = config.appForegroundUrl

    override fun applicationBackgroundUrl(): String = config.appBackgroundUrl
}
